/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/dial/Demo/RCS/multidial.c,v 1.5 1994/02/25 04:45:57 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>

#include "Dial.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN		0
#define MAX		100
#define NUMDIALS	9

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

static XrmOptionDescRec options[] = {
  {"-face",	"*dial.faceBorderColor",	XrmoptionSepArg,	NULL},
  {"-needle",	"*dial.needleBorderColor",	XrmoptionSepArg,	NULL},
  {"-fill",	"*dial.needleColor",		XrmoptionSepArg,	NULL},
  {"-tick",	"*dial.tickColor",		XrmoptionSepArg,	NULL},
  {"-value",	"*dial.showValue",		XrmoptionNoArg,		"TRUE"},
};

Syntax(call)
char *call;
{
  printf("Usage: onedial\n");
  printf("\t-face <color>\n");
  printf("\t-needle <color>\n");
  printf("\t-fill <color>\n");
  printf("\t-tick <color>\n");
  printf("\t-value\n");
  exit(1);

} /* Syntax */

void main(argc, argv)
int argc;
char **argv;
{
  int		i, j, argi, value;
  Widget	w, top, form, dial[NUMDIALS];
  Arg		arglist[20];
  XEvent	event;

  top = XtInitialize("main", "XDial", options,
		     XtNumber(options), &argc, argv);

  if (argc != 1)
    Syntax(argv[0]);

  form = XtCreateManagedWidget("form", formWidgetClass, top, NULL, ZERO);

  w = NULL;
  argi = 0;
  SetArg(XtNwidth, 100);
  SetArg(XtNheight, 100);
  SetArg(XtNminValue, MIN);
  SetArg(XtNmaxValue, MAX);
  SetArg(XtNselect, selectcallback);
  for (i=0; i<NUMDIALS; i++) {
    argi = 6;
    if ((i%3) == 0) {
      SetArg(XtNfromVert, w);
      SetArg(XtNvertDistance, 10);
      SetArg(XtNfromHoriz, NULL);
      SetArg(XtNhorizDistance, 10);
      dial[i] = XtCreateManagedWidget("dial", dialWidgetClass,
				      form, arglist, argi);
    }
    else {
      SetArg(XtNfromVert, w);
      SetArg(XtNvertDistance, 10);
      SetArg(XtNfromHoriz, dial[i-1]);
      SetArg(XtNhorizDistance, 10);
      dial[i] = XtCreateManagedWidget("dial", dialWidgetClass,
				      form, arglist, argi);
      if (((i+1)%3) == 0)
	w = dial[i];
    }
  }
  XtRealizeWidget(top);

  for (i=0; i<NUMDIALS; i++) {
    value = MIN + (MAX-MIN)*(getvalue() / 100.0);
    DialSetValue(dial[i], value);
  }
  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
    sleep(1);
    for (i=0; i<NUMDIALS; i++) {
      value = MIN + (MAX-MIN)*(getvalue() / 100.0);
      DialSetValue(dial[i], value);
    }
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value = %d\n", value);

} /* Select */
