.TH "Dial" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Dial \- A dial widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNminValue:int:0:minimum value
XtNmaxValue:int:100:maximum value
XtNvalue:int:0:needle value (minvalue - maxvalue)
XtNfaceBorderColor:Pixel:"black":face border color
XtNfaceColor:Pixel:"white":face color
XtNneedleColor:Pixel:"black":needle color
XtNneedleBorderColor:Pixel:"black":needle border color
XtNtickColor:Pixel:"black":tick color
XtNselect:XtCallbackList:NULL:callbacks for dial selection
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:samples current dial value
notify:invokes the dial select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBDialSetValue\fR(w, v)
DialWidget w;
int v;
.fi
.sp
DialSetValue() set the current value of the dial to v.
The dial display is automatically updated.
.ne 4
.SH DESCRIPTION
.br
The \fBDial\fR widget manages a circular display of a dial.
A needle is drawn to show the current value of the dial where
the minimum value is at 12 o'clock
and values increase clockwise on the dial.
The user sets the minimum and maximum values the dial will show.
Dial values must be in this range.
Tick marks are shown on the dial (default 100) with major ticks every
5 ticks.
There are color resources for all components of the dial.
.PP
Clicking the left mouse button on a dial invokes a callback function
with the current value of the dial. 
.ne 8
.SH FUTURE ENHANCEMENTS
.br
The following resources will be added in the future:
.sp
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNbeginDegree:int:0:beginning degree for dial
XtNendDegree:int:360:ending degree for dial
XtNclockwise:Boolean:FALSE:rotation is clockwise
XtNnumTicks:int:100:number of ticks in dial range
XtNmajorTick:int:5:ticks per major tick
.TE
.sp
The dial will be specified by an arc of the full circle given by a
beginning degree and an ending degree.
Clockwise rotation indicates that increasing values will be
shown in clockwise order.
The number of ticks and the ticks per major tick will be settable.
.PP
An additional callback may be supported in the future.
Clicking the middle mouse button will set the dial value to that
value closest to the mouse position and call any registered callbacks.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
