.TH "Gantt" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Gantt \- A gantt chart widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNxmin:int:0:minimum x axis value
XtNxmax:int:100:maximum x axis value
XtNymin:int:0:minimum y axis value
XtNymax:int:100:maximum y axis value
XtNxticks:int:5:number of x axis tick marks
XtNyticks:int:5:number of y axis tick marks
XtNtickColor:Pixel:"black":tick color
XtNcolors:Pixel*:NULL:line colors
XtNnumColors:int:0:number of line colors
XtNorientation:XtOrientation:vertical:gantt orientation
XtNselect:XtCallbackList:NULL:callbacks for gantt selection
.TE
.sp
XtOrientation: vertical, horizontal
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records x and y position of mouse in gantt coordinates
notify:invokes the gantt select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBGanttSetColorMap\fR(w, numcolors, colors)
GanttWidget w;
int numcolors;
Pixel *colors;
.fi
.sp
GanttSetColorMap() establishes a color map for gantt lines.
The gantt display is automatically updated.
.sp
.nf
void \fBGanttAddLine\fR(w, lid, n, color, x, y)
GanttWidget w;
int lid;
int n;
int color;
int *x, *y;
.fi
.sp
GanttAddLine() creates a new line in the gantt display.
The argument lid gives the id of the line, n is the number of points
in the line, cid is the color choice, and x and y are pointers to
arrays of x and y coordinate values, respectively.
GanttShowGantt() must be called before the new line is displayed.
By default, new lines are mapped.
.sp
.nf
void \fBGanttDeleteLine\fR(w, lid)
GanttWidget w;
int lid;
.fi
.sp
GanttDeleteLine() deletes the line lid.
GanttShowGantt() must be called before the line is
removed from the display.
.sp
.nf
void \fBGanttMapLine\fR(w, lid)
GanttWidget w;
int lid;
.fi
.sp
GanttMapLine() maps (i.e. displays) the line lid in the gantt chart.
.sp
.nf
void \fBGanttUnMapLine\fR(w, lid)
GanttWidget w;
int lid;
.fi
.sp
GanttUnMapLine() unmaps (i.e. erases) the line lid in the gantt chart.
.sp
.nf
void \fBGanttShowGantt\fR(w)
GanttWidget w;
.fi
.sp
GanttShowGantt() draws the gantt chart.
.sp
.nf
void \fBGanttClearGantt\fR(w)
GanttWidget w;
.fi
.sp
GanttClearGantt() clears the gantt chart.
.ne 4
.SH DESCRIPTION
.br
The \fBGantt\fR widget draws lines within a region defined by the x
and y axes.
Each line is represented by a list of points which are drawn as a
single connected line.
Each line has its own color selector which is an index into a line
color table.
Lines can be added and deleted to the gantt widget as well as map
and unmapped in the display.
.PP
A callback is supported.  The line identifier and the nearest line point
are returned to any registered callbacks.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
A future version of the gantt widget will provide a capability for
drawing the list of points representing a line as a group of
line segments.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
