.TH "Graph" "5-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
graph - A graph input meta-language.
.ne 4
.SH DESCRIPTION
.br
The meta-language used for representing graphs for
input to the graph widget is described below.
The format is strict and consists of single line commands.
.sp
The following lists the commands defined in the graph meta-language.
A '%' can be use for commenting the graph input (all characters from
the '%' to the end of the line are ignored).
All coordinates are in a virtual positive 2-D
integer space defined by the user (e.g. 10000 x 10000).
The curly brackets indicate optional arguments.
.sp
.in 3.5i
.ta 2.5i
.ti 0.5i
\fBg\fR  <number of nodes>  {"graph title"}
.br
.ti 0.75i
Graph command.
.sp
.ti 0.75i
<number of nodes>	: integer number of nodes in the graph
.br
.ti 0.75i
"graph title"	: ascii title of graph enclosed in quotes
.sp
.ti 0.5i
\fBn\fR  <node id>  <x>  <y>  {"node name"}
.br
.in 0.75i
Node command.  This command must appear before any links with this
node as the from node.
.in 3.5i
.sp
.ti 0.75i
<node id>	: integer node id
.br
.ti 0.75i
<x>	: integer "virtual" x coordinate of node center
.br
.ti 0.75i
<y>	: integer "virtual" y coordinate of node center
.br
.ti 0.75i
"node name"	: ascii name of node enclosed in quotes
.sp
.ti 0.5i
\fBl\fR  <from>  <to>  {-<directional>}
.br
.ti 0.75i
Link command.
.sp
.ti 0.75i
<from>	: integer node id representing "from" node of link
.br
.ti 0.75i
<to>	: integer node id representing "to" node of link
.br
.ti 0.75i
<-directional>	: boolean (0,1) indicating whether or not the link is
directional; note, the '-' is required
.ne 4
.SH EXAMPLE
.br
Suppose we want to describe the following graph in the above graph
meta-language:
.sp
.ft L
.nf
                            Graph Example

                                  0 (500,0)
                                 / \\
                                /   \\
                               /     \\
                (250, 500)    1------>2 (750,500)
                               \\     /
                                \\   /
                                 \\ /
                                  3 (500, 1000)
.fi
.ft P
.sp
The graph description would be:
.sp
.ta 2i
.nf
g  3  "Graph Example"
n  0  500  0  "0"
l  0  1  -0
l  0  2  -0
n  1  250  500  "1"
l  1  2  -1
l  1  3
n  2  750  500  "2"
l  2  3	% optional directional argument left out
n  3  500  1000	% optional node name left out
.fi
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
