.TH "Interval" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Interval \- An interval widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNminValue:int:0:minimum interval value
XtNmaxValue:int:100:maximum interval value
XtNorientation:XtOrientation:vertical:interval orientation
XtNselect:XtCallbackList:NULL:callbacks for interval selection
.TE
.sp
XtOrientation: vertical, horizontal
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records x and y position of mouse in interval coordinates
notify:invokes the interval select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBIntervalSetIntervals\fR(w, num, low, high, index)
IntervalWidget w;
int num;
int *low, *high, *index;
.fi
.sp
IntervalSetIntervals() loads a new set of intervals into the interval
widget and updates the display.
.sp
.nf
void \fBIntervalSetColors\fR(w, numcolors, colors)
IntervalWidget w;
int numcolors;
Pixel *colors;
.fi
.sp
IntervalSetColors() loads a new interval color map.
.sp
.nf
void \fBIntervalSetPixmaps\fR(w, numpixmaps, pixmaps)
IntervalWidget w;
int numpixmaps;
Pixmap *pixmaps;
.fi
.sp
IntervalSetPixmaps() loads a new interval pixmap table.
.sp
.nf
void \fBIntervalUpdate\fR(w)
IntervalWidget w;
.fi
.sp
IntervalUpdate() redraws the interval display.
.ne 4
.SH DESCRIPTION
.br
The \fBInterval\fR widget draws a rectangular region in the chosen
orientation in which sub-intervals or "intervals" can be defined.
Each interval has an associated index into a color map or pixmap
table.
For indexes >= 1, colors from the color map are used to fill the
interval region.
For indexes <= -1, pixmaps from the pixmap table are used to fill the
interval region.
.PP
A callback is supported.  With horizontal orientation,
the x position relative to interval min and
max values are returned to any registered callbacks.
Similarly, with vertical orientation, the y position relative to interval
min and max values are returned to registered callbacks.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
None are planned at this time.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
