#include <fork.h>
#include <syscall.h>
#include <io.h>

#define N 3
#define T 16
#define busT 10      /* length of critical section */
#define NOBUS 1

#define SHEAPSIZE 1024
#define BLOCKSIZE 1
#define AVAILSIZE 1024

sh char sheap[SHEAPSIZE];
sh int offset = 0;
sh char *avail[AVAILSIZE];
sh int high = 0, low = 0;

sync char *newblock( void ) {
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  if (my_offset >= SHEAPSIZE) {
     farm pprintf("newblock failed!\n"); 
     return NULL;
  }
  else return sheap + my_offset;
}

async char *asy_newblock( void ) {
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  if (my_offset >= SHEAPSIZE) {
     pprintf("newblock failed!\n"); 
     return NULL;
  }
  else return sheap + my_offset;
}

sh simple_lock lowhighlock = 0;

async char *seqballoc( void ) {
  pr int pos;
  simple_lockup( &lowhighlock );
  if (low < high) {
     pos = low++; 
     simple_unlock( &lowhighlock );
     return avail[ pos % AVAILSIZE ];
  }
  else {
     simple_unlock( &lowhighlock );
     return asy_newblock();
  }
}

async void seqbfree( pr char *ptr ) {
  pr int pos;
  simple_lockup( &lowhighlock );
  if (high-low < AVAILSIZE)
     avail[high++] = ptr;     /* else forget it */
  simple_unlock( &lowhighlock );
}


/* modes of balloc: */
#define ALLOC 1
#define FREE 0

sync char *balloc( pr char *ptr, pr int mode ) {
  pr int my_index;
#if 0
  pprintf("balloc %d\n", mode);
#endif
  if (mode == FREE) {
     /* insert block ptr into list of available blocks. */
     my_index = mpadd( &high, 1 );
     /* now the new values of high and low are valid, see else case */
     avail[my_index % AVAILSIZE] = ptr;
#if 0
     pprintf("inserting %p to position %d\n", ptr, my_index );
#endif
  }
  else {   /* mode == ALLOC */
     my_index = mpadd( &low, 1 );
  }
  if (high - low > AVAILSIZE)  {  /* Test on overflow */
     farm pprintf("balloc: avail buffer full!\n");
     return NULL;
  }
  if (mode == ALLOC) {
     /* take available block from queue or acquire a new one */
     if (my_index >= high) {
        /* cannot get block from avail queue. */ 
        my_index = mpadd( &low, -1 );   /* repair low */
#if 0
        pprintf("acquiring new block\n");
#endif
  if (high < low )  {  /* Test on consistency */
     farm pprintf("balloc: inconsistent!\n");
     return NULL;
  }
        return newblock();
     } else {
#if 0
        pprintf("dequeuing position %d\n", my_index);
#endif
        return avail[my_index % AVAILSIZE];
     }
  }
}


main() 
{
  pr int i, t;
  pr char *p;
  _ticket[0] = 0;
  _gone[0] = 0;
  lowhighlock = 0;
  barrier;
  for (i=0; i<$; i++) t = rand();
  for (i=0; i<N; i++) {
    int myT = rand() % T;
    for (t=0; t<myT; t++) ;
    if ($==0) pprintf("i=%d\n", i);
#if NOBUS
    simple_lockup( &lowhighlock );
    write(1,"+",1);
    for (t=0; t<busT; t++) ;
    simple_unlock( &lowhighlock );
#else
    join(0, for(t=0;t<4;t++), 0, 100, 1, write(1,"*",1);for (t=0;t<busT;t++), write(1,"-",1);for(t=0;t<3;t++));
#endif
  }
  barrier;
}

