From marr@dcs.ed.ac.uk  Wed Mar 29 17:34:01 1995
Date: Wed, 29 Mar 1995 16:05:05 +0100
From: Marcus Marr <marr@dcs.ed.ac.uk>
Subject: Fork95 - mpadd()
To: "Christoph W. Kessler" <kessler@TI.Uni-Trier.DE>
Content-Length: 2060

Dear Christoph,

Sorry to bother you again, but I'm having problems using mpadd().  Are
you allowed to give it a private variable for the second argument?  I
need to be able to do this to write the 'wrapper' functions I mailed
you last time.  

The problem arises when I use an inclusive add of the form:

	sh int sum=0;
	pr int v;

	v=$;
	v+=mpadd(&sum,v);

It seems to store the result of mpadd() in 'v' before the addition
takes place, with the result that it gives me twice the exclusive sum
instead.  The following, however, works:

	sh int sum=0;
	pr int v,w;

	v=$; w=v;
	v=w+mpadd(&sum,v);

A full test program is included at the end of this email, followed by
the test output.

I'm not too bothered with it at the moment since I can get the results
I'm looking for, but I thought you'd like to know.

Thanks for your help,

Marcus


#include <fork.h>
#include <io.h>

#define print_results(S)                                          \
    if ($==0) farm { prS(S); prS(": { "); }                       \
    for (i=0;i<__STARTED_PROCS__;i++) {                           \
	if ($==i) farm { prI(v,0); prS(" "); }                    \
    }                                                             \
    if ($==0) farm { prS("} with sum "); prI(sum,0); prS("\n"); }

async void main( void )
{
    start {
	sh int i,sum,*x;
	pr int v,w;

	sum=0; v=$; 
	v=mpadd(&sum,v);
	print_results("exclusive sum    ");	

	x=(int*)shalloc(__STARTED_PROCS__*sizeof(int));
	sum=0; x[$]=$;
	x[$]+=mpadd(&sum,x[$]);
	v=x[$];
	print_results("inclusive sum (a)");

	sum=0; v=$; 
	v+=mpadd(&sum,v);
	print_results("inclusive sum (b)");

	sum=0; v=$; w=v;
	v=w+mpadd(&sum,v);
	print_results("inclusive sum (c)");
    }
}


/* Output:

PRAM P0 = (p0, v0)> g
exclusive sum    : { 0 0 1 3 6 10 15 21 } with sum 28
inclusive sum (a): { 0 1 3 6 10 15 21 28 } with sum 28
inclusive sum (b): { 0 0 2 6 12 20 30 42 } with sum 28
inclusive sum (c): { 0 1 3 6 10 15 21 28 } with sum 28
EXIT: vp=#0, pc=$00000a8c
Stop nach 44648 Runden, 803.728 kIps
0a8c 18137FFF  POPNG    R6, ffffffff, R1

*/

Hi again,

> This side effect is NOT a bug but a feature of mpadd()! 

Thanks for clearing that up.  I hope you don't mind me bothering you
like this, but I'm sure you will agree that the feature is not
immediately obvious!

> If you agree, I will include this into the example programs
> to make the functionality of mpadd() more clear for all Fork95
> programmers.

No problem.  You may be interested in my 'mpadd_inc()' function:

	sync pr int mpadd_inc(sh int *add, pr int val) {
	    pr int local_val;
	    local_val=val;
	    return local_val+mpadd(add,val);
	}

Thanks for all your help,

Marcus
