/*  philo_naiv.c   by C.W.Kessler 11/95
 *
 *  Dining philosophers: demo program 1 in Fork95
 *  Modified simple-lock version, still NOT deadlock-free!
 *  (play around with parameters N,maxHunger,Denkzeit,Wartezeit).
 *  We use NOT the simple_lock type defined in <fork.h> because
 *  of pedagogical reasons. Atomic lock operations are explicitly
 *  programmed using the built-in atomic mpmax()-operator.
 */

#include <fork.h>
#include <stdlib.h>
#include <io.h>

#define maxN 4096     /* max. Anzahl Philosophen */
#define T 10          /* so oft soll jeder Philosoph essen */
#define Denkzeit 1    /* soviel mal 6 Takte wartet jeder Philosoph
                         nach dem Essen, bis er wieder hungrig wird */
#define maxHunger (4*Denkzeit+100)
                      /* nach soviel vergeblichen Versuchen
                         sei ein Philosoph verhungert */

sh int N;             /* Anzahl der Philosophen */
sh int G[maxN];       /* Feld von N Locks, eins fuer jede Gabel */
                      /* G[x] steht fuer die Gabel links von Philosoph x,
                       * G[(x+1)%N] rechts von ihm, x=0,...,N-1. */
pr int hungrig = 0;   /* gibt an, wie hungrig ein jeder Philosoph ist */
pr int habe_schon = -1;  /* merke Nr. der Gabel, die ich als erste
                            aufgenommen habe. -1, falls keine. */


void denken( void )
{
  pr i;
  for (i=0; i<Denkzeit; i++)  ;
}


void warten( pr int Wartezeit )
{
  pr i;
  for (i=0; i<Wartezeit; i++)  ;
}


void hinlegen( pr int Gabelnr )
{
  pprintf(" Gabel %d hingelegt\n", Gabelnr );
  G[Gabelnr] = 0;                  /* STG ist atomar auf SB-PRAM */
}


void aufnehmen( pr int Gabelnr )
{
 pprintf(" versuche Gabel %d aufzunehmen\n", Gabelnr );
 do {
    pr int besetzt = mpmax( &(G[Gabelnr]), 1 ); /* test&set */
    if (!besetzt) break;
    hungrig++;
    if (hungrig > maxHunger) {
        pprintf(" +++++++ verhungert! +++++++ %d\n", habe_schon);
        if (habe_schon > -1)
           hinlegen( habe_schon );   /*Loeffel, aeh Gabel abgeben*/
        while(1);   /*Nirwana*/
    }
    warten( rand()%(4*N) );    /* <-- Deadlock--sensitiver Wert! */
 } while (1);
 /* jetzt gehoert die Gabel mir */
 pprintf(" Gabel %d aufgenommen\n", Gabelnr );
}


void main( void ) 
{
 pr int i;
 N = __STARTED_PROCS__;        /* soviel Philosophen wie Prozessoren */
 G[$] = 0;                     /* parallel das Gabelfeld initialisieren */
 if ($==0) pprintf(" %d Dining Philosophers\n\n", N );
 barrier;                      /* Ende aller Initialisierungen abwarten */
 for (i=0; i<T; i++) {
    if ($%2) {
      aufnehmen( $ );       /* beschaffe linke Gabel zuerst */
      habe_schon = $;
      aufnehmen( ($+1)%N ); /* dann beschaffe rechte Gabel */
    }
    else {
      aufnehmen( ($+1)%N ); /* beschaffe rechte Gabel zuerst */
      habe_schon = ($+1)%N;
      aufnehmen( $ );       /* dann beschaffe linke Gabel  */
    }
    pprintf(" Mampf, Runde %d\n", i);  /* essen */
    hungrig = 0;
    hinlegen( $ );        /* linke Gabel hinlegen */
    hinlegen( ($+1)%N );  /* rechte Gabel hinlegen */
    habe_schon = -1;
    denken();             /* warten */
    hungrig = 1;
 }
 pprintf("fertig!\n");
 barrier;    /* verhungerte Prozessoren warten am barrier in der
              * Funktion aufnehmen(), das sich auf die gleiche 
              * Sync-Zelle (gleiche Gruppe) bezieht */
}
