/*  philo.c   by C.W.Kessler 11/95
 *
 *  Dining Philosophers, demo program 2 in Fork95
 *  This deadlock-free version may still be not fair;
 *  play around with parameters N,maxHunger,Denkzeit,Wartezeit.
 *  A philosopher tries to get both forks at once.
 *  If he doesn't get both of them, he immediately releases
 *  the fork that he possibly got, and waits for a
 *  randomly chosen amount of time before trying again.
 */

#include <fork.h>
#include <stdlib.h>
#include <io.h>

#define maxN 4096     /* max. Anzahl Philosophen */
#define T 10          /* so oft soll jeder Philosoph essen */
#define Denkzeit N    /* soviel mal 6 Takte wartet jeder Philosoph
                       * nach dem Essen, bis er wieder hungrig wird */
#define maxHunger (N*Denkzeit+200) /* nach soviel vergeblichen Versuchen
                       * sei ein Philosoph verhungert */

sh int N;             /* Anzahl der Philosophen */
sh int G[maxN];       /* Feld von N Locks, eins fuer jede Gabel */
                      /* G[x] steht fuer die Gabel links von Philosoph x,
                       * G[(x+1)%N] rechts von ihm, x=0,...,N-1. */
pr int hungrig = 0;   /* gibt an, wie hungrig ein jeder Philosoph ist */


void denken( void )
{
  pr i;
  for (i=0; i<Denkzeit; i++)  ;
}


void warten( pr int Wartezeit )
{
  pr i;
  for (i=0; i<Wartezeit; i++)  ;
}


void hinlegen( pr int Gabelnr )
{
  pprintf(" Gabel %d hingelegt\n", Gabelnr );
  G[Gabelnr] = 0;                  /* STG ist atomar auf SB-PRAM */
}


void beide_aufnehmen( void )
{
 pprintf(" versuche Gabeln %d und %d aufzunehmen\n", $, ($+1)%N );
 do {
    pr int besetzt1 = 0;
    pr int besetzt2 = mpmax( &(G[($+1)%N]), 1 ); /* test&set */
    mpmax( &(G[$]), 1 ); /* test&set */
    if (!besetzt1 && !besetzt2) break;
    if (!besetzt1 && besetzt2) hinlegen($);     /* linke G. zurueck */
    if (besetzt1 && !besetzt2) hinlegen(($+1)%N); /* re. G. zurueck */
    hungrig++;
    if (hungrig > maxHunger) {
        pprintf(" +++++++ verhungert! +++++++ \n");
        while(1);   /*Nirwana*/
    }
    warten( $*__STARTED_PROCS__ );
       /* warte eine zufaellige Zeit bis zum neuen Versuch */
 } while (1);
 /* jetzt gehoeren beide Gabeln mir */
 pprintf(" Gabeln %d und %d aufgenommen\n", $, ($+1)%N );
}


void main( void ) {
 pr int i;
 N = __STARTED_PROCS__;        /* soviel Philosophen wie Prozessoren */
 G[$] = 0;                     /* parallel das Gabelfeld initialisieren */
                               /* da main() synchron begonnen wird, OK */
 srand(8*$*$*$+4*$+17);
 if ($==0) pprintf(" %d Dining Philosophers\n\n", N );
 for (i=0; i<T; i++) {
    beide_aufnehmen();      /* beschaffe beide Gabeln gleichzeitig */
    pprintf(" Mampf, Runde %d\n", i);  /* essen */
    hungrig = 0;
    hinlegen( $ );        /* linke Gabel hinlegen */
    hinlegen( ($+1)%N );  /* rechte Gabel hinlegen */
    denken();             /* warten */
    hungrig = 1;
 }
 pprintf("fertig!\n");
 barrier;   /* verhungerte Prozessoren haengen am barrier in 
             * beide_aufnehemen() (gleiche Sync-Zelle) */
}
