/* PRIME TWINS */
/* primes.balanc.c        standard method, asynchronous implementation,
 *                        with self-scheduling using balanced parallel loop
 * C.W. Kessler 1.12.95 */

#include <fork.h>
#include <io.h>
#include <stdlib.h>
#include <math.h>

#define N 10000

int isprime( int z )
{
  int sqrtz = 1<<(ilog2(z)/2 + 1);    /*approximate the square root of z */
  int i;
  /* pprintf("teste z=%d: sqrtz = %d\n", z, sqrtz);*/
  /* if (z%2) return 0;   not required; z is always odd */
  for (i=3; i<sqrtz; i+=2)
     if (!(z%i))  return 0;
  return 1;
}

sh int cnt = 0;
sh int iter = 1;

main()
{
  int z;
  int i;
  int Ndiv6 = (int) ((float)N/6.0)+1;

  if ($==0)
     pprintf("Untersuche Bereich 1...6*%d\n", Ndiv6);
  while (1) {
     i = mpadd( &iter, 1);
     if (6*i+1>N) break;
     z = 6*i - 1;
     if (isprime( z ) && isprime( z+2 )) {
        mpadd(&cnt,1);
        pprintf(" %d, %d ", z, z+2);
     }
  }
  barrier;
  if ($==0)
     pprintf("\n Das waren %d Primzahlzwillingspaare.\n", cnt);
  barrier;
}
  
