/* This file  "async.c" is based on "sbp_multiproc.h"
 * written by Jochen Roehrig,  (C) 1994 by bird@cs.uni-sb.de 
 * at Saarbruecken University, LS Prof. W.J. Paul, SB-PRAM project,
 * within the framework of the p4gcc compiler libraries.
 * Documentation will be contained in Jochen's Master thesis
 * which will appear 1995 at Saarbruecken University, Germany.
 * Jochen's contribution is greatly appreciated.
 * ---- Christoph W. Kessler, in March 1995.
 */

/* 
 * Implementation of a locking mechanism
 * simple, fair and safe locks: -> forklib2.asm
 * reader-writer-locks: here
 *
 * Implementation of counting barrier synchronization ->forklib2.asm
 *
 * Implementation of a parallel loop mechanism
 * Calculation of a unique id in a process group
 * Implementation of a parallel copy routine
 * Implementation of a parallel fifo queue
 * Implementation of a parallel broadcast queue
 */

#include <fork.h>

pr int __mp_dummyvar;   /* bugfix to make multipraefix work properly */

void fair_lock_init( fair_lock *pfl )
{
  pfl->nextnum = pfl->actnum = 0;
}

/* ############### definition of reader/writer-lock  ############### */

/* we use "mpadd" and "syncor" to acces the memory cell holding the number
 * of readers owning the lock and the writer-acces-flag
 *
 * to be sure that there won't occur an error in a sorting node, in a
 * network node or in a memory unit during access to the memory cell holding
 * the reader counter we'll do "syncor"/"mpadd" only if MODULO == 0/1
 */

#define __RW_FLAG__ 0x40000000  /* 2^30 */
/* we can't use 2^31 since we have to calculate corrrectly -(__RW_FLAG__) 
 * typedef struct {
 *  unsigned int reader_cnt;  * Bits 0-29 are used as reader counter
 *                            * Bit 30 is used as writer-flag
 *  fair_lock writerlock;
 * } rw_lock;
 */

void rw_lock_init( rw_lock *lock)
{
   lock->readercounter = 0;
   lock->writerlock.nextnum = 0;   /* init fair lock */
   lock->writerlock.actnum = 0;    /* init fair lock */
}


void rw_lockup( rw_lock *lock, int ptype)
{
 int wait;
 if(ptype == RW_READ) {         /* reader-lock */
    wait = 1; /* wait = TRUE */
    while(wait) {
       wait = 0; /* wait = FALSE */
       /* wait for writer to leave the lock */
       while( mpadd(&(lock->readercounter), 0) & __RW_FLAG__ );
       /* writer has finished - now try to catch lock */
       if( mpadd(&(lock->readercounter), 1) & __RW_FLAG__ ) {
          /* another writer was faster than me */
          mpadd( &(lock->readercounter), -1); 
          /* undo lock */
          wait = 1; /* wait = TRUE */
       }
    }
 }
 else {      /* writer-lock */
    /* wait for writer to leave the lock */
#if 0
    unsigned int rc = lock->readercounter;
#endif
    fair_lockup(&(lock->writerlock));
    /*  set flag to indicate to the readers that I want to have the lock */
#if 0
    asm("bmc    0\n\
         gethi  0x40000000,r31 /*__RW_FLAG__*/\n\
         syncor r31,%rc\n\
         nop    /*delay*/");
         /*\n\ nop    \n\ stg    r31,r30,0 */
#endif
    syncor( (int *)&(lock->readercounter), __RW_FLAG__ );
    /* wait for readers to leave the lock */
    while( mpadd( &(lock->readercounter), 0) & (__RW_FLAG__-1));
    /*     ^^^^^ Zuweisung an Dummy koennte Probleme machen. -> asm */
    /*     evtl. benutze syncor()-Routine */
 }
} /* _rw_lockup() */


int rw_unlock( rw_lock *lock, int ptype, int wait)
{
 int dummy;
 if(ptype == RW_READ)    /* reader-unlock */
    dummy = mpadd ( &(lock->readercounter), -1);
 else {   /* writer-unlock */
    int i;
    /* free lock for readers */
    mpadd ( &(lock->readercounter), -__RW_FLAG__);      
    /* wait loop */
    for(i = 0; i < wait; i++);
    /* free for writers */
    fair_unlock(&(lock->writerlock));
 }
} /* _rw_unlock() */


#if 0

/* ############### parallel loop ############### */

/*
 * sbp_parloop_t
 */

typedef struct {
   int index;
   sbp_barrier_t sync;
} sbp_parloop_t;

/*
 * sbp_parloop_init()
 */

void sbp_parloop_init(sbp_parloop_t *pl)
{
   pl->index = 0;
   sbp_barrier_init(&(pl->sync));
} /* sbp_parloop_init */
 
/*
 * sbp_parloop()
 */

void sbp_counter_set(void *counter_and_value);
	/* this function will be called during synchronization to reset the
	   loop index */

int sbp_parloop(sbp_parloop_t *pl, int max, int nprocs, int stride)
{
   int oldind;
   unsigned int cnt_set[2]; /* used to reset counter */
	
   if((oldind = sbp_mpadd_m1(&(pl->index), stride)) > max)
   /* oldind > max ==> loop end, synchronize processes, reinitalize pl->index
      and assign -1 to oldind */
   {
	   cnt_set[0] = (unsigned int)(&(pl->index));
	   cnt_set[1] = (unsigned int)0;

      sbp_barrier(&(pl->sync), nprocs, sbp_counter_set, (void *) cnt_set);

      oldind = -1;
   }
   return oldind;
} /* sbp_parloop */

/* ############# calculation of a unique id in a process group  ############ */

unsigned int sbp_get_id_in_group(unsigned int procs_in_group, unsigned int *counter,
				 sbp_barrier_t *barrier)
{
	unsigned int id;
	unsigned int cnt_set[2]; /* used to reset counter */

	/* reset counter - just to be sure */

	cnt_set[0] = (unsigned int)counter;
	cnt_set[1] = (unsigned int)0;

	sbp_barrier(barrier, procs_in_group, sbp_counter_set, (void *)cnt_set);

	/* get id */

	id = sbp_mpadd(counter, 1);

	/* synchronize processes */

	sbp_barrier(barrier, procs_in_group, NULL, NULL);
	
	return id;
	
} /* sbp_get_id_in_group() */


/* ############### parallel queue/broadcast queue ############### */

/* #define log2_floor(value)  in async.h*/

/*
 * maximum queue size
 * #define SBP_MAX_PQ_LOG 13 * there are 2^SBP_MAX_PQ_LOG lists *
 * #define SBP_MAX_BQ_LOG 13 * there are 2^SBP_MAX_BQ_LOG lists * 
 */
/*
 * dummy queue element
 */
/* the definition of "sbp_pq_ele" and "sbp_bq_ele" must be identical
 * (modulo different names for the struct items 

 * struct __pq_listhd__; * defined below *
 * struct __bq_listhd__; * defined below *

 * typedef struct __sbp_pq_ele__ {
  * * the first four components must correspond to the first four components
    * of "sbp_pq_listhd" *
  * struct __pq_listhd__  *head;    * pointer to head of list stg/ldg on MODULO 0/1 *
  * struct __sbp_pq_ele__ *next;    * to build a doubly linked list *
  * struct __sbp_pq_ele__ *prev;    * to build a doubly linked list *
  * unsigned int missing; * number of removed items at the right of the element *
  * unsigned int dummy1, dummy2; * only used in "sbp_bq_ele" *
 * } sbp_pq_ele;
 * 
 * typedef struct __sbp_bq_ele__ {
  * * the first three components must correspond to the first three components
    * of "sbp_bq_listhd"
  * struct __bq_listhd__  *head;       * pointer to head of list stg/ldg on MODULO 0/1
  * struct __sbp_bq_ele__ *next;       * to build a doubly linked list
  * struct __sbp_bq_ele__ *prev;       * to build a doubly linked list
  * unsigned int id;    * identificator of stored element
  * unsigned int read_start; * decremented when a process starts to read the element access only by mpadd
  * unsigned int read_end;   * decremented when the process has finished to copy the element syncadd_m0/ldg_m1 
 * } sbp_bq_ele;
 * 
 * 
 *
 * SBP_PQ_TYPEDEF/SBP_BQ_TYPEDEF
 *
 * - the first six items correspond to the six items
 *   of "sbp_pq_ele"/"sbp_bq_ele"
 *
 * - both macros are interchangeable
 * 
 * #define SBP_PQ_TYPEDEF(typename, items...)
 *
 * head of a list of queued elements
 */

/*typedef struct __pq_listhd__ { ... } sbp_pq_listhd; */


/*typedef struct __bq_listhd__ { ... } sbp_bq_listhd;*/

/*
 * parallel queue/broadcast queue
 */

/*typedef struct __sbp_parallel_queue__ {
 *  unsigned int q_size;       /* only read access */
 *  int min_num_ele;           /* tdr_m1 & mpadd_m1/syncadd_m0 */
 *  unsigned int read_count;   /* only access by mpadd */
 *  unsigned int write_count;   /* only access by mpadd */
 *  sbp_pq_listhd *listarray;  /* only read access */
 * } sbp_pq;

/*typedef struct __sbp_broadcast_queue__ {
 *  unsigned int q_size;        * only read access *
 *  unsigned int num_procs;     * number of processors thatt use this queue; only read access
 *  int min_num_ele;            * syncadd_m0/ldg_m1
 *  unsigned int write_count;   * only access by mpadd 
 *  unsigned int *read_count;   * holds the id of the next element 
                                  the process wants to read;
                                  there's one counter for each processor
 *  sbp_bq_listhd *list_array;  * array of lists of queued elements only read access
 *  } sbp_bq;
 */

int sbp_pq_noe(sbp_pq *pq)
{
	return sbp_mpadd_m1(&(pq->min_num_ele), 0);
} /* sbp_pq_noe() */


int sbp_bq_noe(sbp_bq *bq, unsigned int id_in_group)
{
	return (sbp_mpadd_m1(&(bq->min_num_ele), 0)
			- bq->read_count[id_in_group]);
} /* sbp_bq_noe() */

#endif
