/* graphic.c   simple graphic output routines    CWK 970324 */
 
#include <fork.h>
#include <stdlib.h>
#include <syscall.h>
#include <graphic.h>
#include <io.h>
#include <string.h>
 
sh pict *Bild = NULL;

void print_pict_info( pict *b )   /* for debug purposes */
{
 printf("height: %d\n", b->Ysize);
 printf("width : %d\n", b->Xsize);
} 
 
sync pict *init_pict( sh int height, sh int breadth )
{
 pict *b = NULL;
 if (height < 0) return NULL;
 if (breadth < 0) return NULL;
 seq {
    b = (pict *)shmalloc( sizeof( pict ));
    b->Ysize   = height;
    b->Xsize   = breadth;
    b->pixel = (int *)  shmalloc( b->Ysize * b->Xsize * sizeof(int));
    Bild = b;
 }
 /*seq print_pict_info( Bild );*/
 return b;
}
 
sync void switch_to_pict( pict *new )
{
  Bild = new;
}


void set_pixel( int x, int y, int color)
{
 pict *b = Bild;
 if (!b) return;
 if (x>=0 && x<b->Xsize && y>=0 && y<b->Ysize  )
    b->pixel[y*b->Xsize + x] = color;
}
 
 
int get_pixel( int x, int y)
{
 pict *b = Bild;
 if (!b) return 0;
 if (x>=0 && x<b->Xsize && y>=0 && y<b->Ysize  )
      return b->pixel[y*b->Xsize+x];
 else return 0;
}
 
 
/* je 2 bit rot, gruen blau: */

#define tabval(c) ((((c)&0xc00000)>>18) + (((c)&0xc000)>>12) + (((c)&0xc0)>>6))

char nl='\n';
char anf='"';
char tab='\t';



sync void write_pixmap( const char *name )
{
  int i,j;
  FILE *Fout;
  int out;
  sh int *line,*pline;
  int procs=groupsize();
  sh pict *b = Bild;
  char *filename;
 
  if (!b) { seq { printf("Fatal error: No picture!\n"); } return; }
  seq {
    print_pict_info( b );
    printf("\nWriting image ");
    filename=malloc(strlen(name)+5);
    strcpy(filename,name);
    i=strlen(name);
    *(filename+i)='.';
    *(filename+i+1)='x';
    *(filename+i+2)='p';
    *(filename+i+3)='m';
    *(filename+i+4)='\0';
    Fout = fopen(filename, "w"); 
    if (!Fout) { printf("Fehler!\n"); exit(1); }
    out=Fout->fd;
    write(out,"/* XPM */",9);   /*Spaces sind kritisch!*/
    printf("to %s\n", filename );
    write(out,&nl,1);
    write(out,"static char *",13);
    write(out,name,strlen(name));
    write(out,"_xpm[] = {",10);
    write(out,&nl,1);
      
    line=shmalloc( b->Xsize + 6 );
    *line=anf;
    *(line+b->Xsize+1)=anf;
    *(line+b->Xsize+2)=',';
    *(line+b->Xsize+3)='\n'; 
    *(line+b->Xsize+4)='\0'; 
    write(out,line,1);
    fprintf(Fout,"%d %d 64 1",b->Xsize, b->Ysize );
    write(out,line+b->Xsize+1,3);
 
    printf("Writing color table ...\n");
    for(i=0;i<64;i++)
	fprintf(Fout, "%c%c%cc rgb:%x/%x/%x%c,%c",
                anf, i+48, tab, ((i&0x30)<<2)|((i&0x30)>>2), 
                ((i&0xc)<<4)|((i&0xc)<<2),
                ((i&0x3)<<6)|((i&0x3)<<4), anf,nl);
 } 
 seq printf("Writing picture ...\n");
 pline=b->pixel;
 for ( i=0; i<b->Ysize; i++, pline+=b->Xsize  ) { 
   for ( j=$; j<b->Xsize; j+=procs) 
      *(line+1+j)=48 + tabval(*(pline+j));
   seq {
      if(i==b->Ysize-1){
           *(line+b->Xsize+2)='}'; 
           *(line+b->Xsize+3)=';'; 
           *(line+b->Xsize+4)='\0'; 
           write(out,line,b->Xsize+4);
      }
      else
          write(out,line,b->Xsize+4);
   }
 }
 seq {
    fclose( Fout );
    shfree(line);
    free( filename );
 }
}
 

void set_line_pixels( int x, int y, int color, int intensity)
{
 set_pixel(x,y,color);

 if (intensity>=2) {
   set_pixel( x, y-1,color);
   set_pixel( x+1, y,color);
   set_pixel( x+1, y-1,color);
 }
 if (intensity>=3) {
   set_pixel( x, y-2,color);
   set_pixel( x+1, y-2,color);
   set_pixel( x+2, y,color);
   set_pixel( x+2, y-1,color);
   set_pixel( x+2, y-2,color);
 }
}

sync void clear_pixels( int c )
{
 int i, j, q, *h;
 int p = groupsize();
 sh pict *bild = Bild;
 farm {
  h = (bild->pixel) + $*(bild->Xsize);
  q = (p-1) * (bild->Xsize);
  for (i=$; i<(bild->Ysize); i+=p, h+=q)
    for (j=0; j<bild->Xsize  ; j++,h++)
      *h=c;
 }
}

/*********************************************************************
 * Bresenham-Algorithmus: Darstellung von Linien		     *
 * Linie der Farbe color von (x1,y1) nach (xn,yn) 		     *
 *********************************************************************/
#define MAXINT 0x7fffffff

extern void set_line_pixels(int,int,int,int);

void seq_line ( int x1, int y1, int xn, int yn, int color, int width )
{
  int error,x,y,dx,dy,m,h;

  if (x1>xn) {                    /* OKTAND 3,4,5 ODER 6? */
    h = x1; x1 = xn; xn = h;      /* Anfangs- und Endpunkt vertauschen */
    h = y1; y1 = yn; yn = h;      /* Weiter analog zu Oktand 7,8,1 oder 2 */
  }
  dx = xn-x1;                     /* x-Differenz bilden */
  dy = yn-y1;                     /* y-Differenz bilden */
  if (dx!=0)                      /* LINIE NICHT VERTIKAL? */
    m = dy/dx;                    /* Steigung berechnen */
  else                            /* LINIE VERTIKAL */
    if (dy>=0)                    /* LINIE SENKRECHT NACH OBEN? */
      m = MAXINT;                 /* Maximale Steigung */
    else                          /* LINIE SENKRECHT NACH UNTEN */
      m = -MAXINT;                /* Minimale Steigung */

  /*if (m == 0) width = (int) ((double)width * 0.67);*/

  if ((m==0) || (dx==abs(dy)))    /* STEIGUNG ZWISCHEN -1 UND 1? */
    if (dy>=0) { 		  /* 1. OKTAND? */
      error = -dx/2;              /* Abw. von Ideallinie initialisieren (negativ) */
      y = y1;                     /* y-Koordinate mit Anfangspunkt initialisieren */
      for (x = x1; x<=xn; x++) {  /* FUER x-Koordinate VON ANFANGS- BIS ENDPUNKT */
	set_line_pixels(x,y,color,width);
	error += dy;              /* Fehler erhoeht sich um dy */
	if (error>=0) {           /* y-KOORDINATE VERSCHIEBT SICH */
	  y++;                    /* Zum tieferen Pixel uebergehen */
	  error -= dx;            /* Fehler verringert sich um dx */
	}
      }
    }
    else { 			  /* 8. OKTAND? */
      error = -dx/2;              /* Abw. von Ideallinie initialisieren (negativ) */
      y = y1;                     /* y-Koordinate mit Anfangspunkt initialisieren */
      for (x = x1; x<=xn; x++) {  /* FUER x-Koordinate VON ANFANGS- BIS ENDPUNKT */
	set_line_pixels(x,y,color,width);
	error -= dy;              /* Fehler erhoeht sich um -dy */
	if (error>=0) {           /* y-KOORDINATE VERSCHIEBT SICH */
	  y--;                    /* Zum hoeheren Pixel uebergehen */
	  error -= dx;            /* Fehler verringert sich um dx */
	}
      }
    }
  else
    if (dy>=0) { 		  /* 2. OKTAND? */
      error = -dy/2;              /* Abw. von Ideallinie initialisieren (negativ) */
      x = x1;                     /* x-Koordinate mit Anfangspunkt initialisieren */
      for (y = y1; y<=yn; y++) {  /* FUER y-Koordinate VON ANFANGS- BIS ENDPUNKT */
	set_line_pixels(x,y,color,width);
	error += dx;              /* Fehler erhoeht sich um dx */
	if (error>=0) {           /* x-KOORDINATE VERSCHIEBT SICH */
	  x++;                    /* Zum rechten Pixel uebergehen */
	  error -= dy;            /* Fehler verringert sich um dy */
	}
      }
    }
    else { 			  /* 7. OKTAND? */
      error = dy/2;               /* Abw. von Ideallinie initialisieren (negativ) */
      x = x1;                     /* x-Koordinate mit Anfangspunkt initialisieren */
      for (y = y1; y>=yn; y--) {  /* FUER y-Koordinate VON ANFANGS- BIS ENDPUNKT */
	set_line_pixels(x,y,color,width);
	error += dx;              /* Fehler erhoeht sich um dx */
	if (error>=0) {           /* x-KOORDINATE VERSCHIEBT SICH */
	  x++;                    /* Zum rechten Pixel uebergehen */
	  error += dy;            /* Fehler verringert sich um -dy */
	}
      }
    }
}


sync void line ( int x1, int y1, int xn, int yn, int color, int width )
{
 seq seq_line ( x1, y1, xn, yn, color, width );
}



