/* adapted for Fork95 by CWK 950401 */

/* Copyright (C) 1991 Free Software Foundation, Inc.
Material in this file was part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <fork.h>
#include <io.h>    /*fuer Debug-Zwecke CWK*/
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>
extern void *memcpy( void *, const void *, size_t);

#define PTR void *
#define ULONG_MAX ((unsigned)0xffffffff)
#define LONG_MAX (0x7fffffff)
#define LONG_MIN (-(int)0x7fffffff)
#define HUGE_VAL 0x7fffffff
#define DBL_MAX (1.0e99)
#define DBL_MIN (-1.0e99)

#define ERANGE 4711     /* some stupid value to make it compile */

extern int errno;


#include "shmalloc.c"

#if 0
/* This stuff is not usable for FORK.    CWK */

/* Register FUNC to be executed by `exit'.  */
int atexit( void (*func)(void) )
{
  extern struct exit_function __new_exitfn();
  struct exit_function *new = __new_exitfn();

  if (new == NULL)
    return -1;

  new->flavor = ef_at;
  new->func.at = func;
  return 0;
}


static struct exit_function_list fnlist = { NULL, 0, };
struct exit_function_list *__exit_funcs = &fnlist;

struct exit_function * __new_exitfn ( void )
{
  register struct exit_function_list *l;

  for (l = __exit_funcs; l != NULL; l = l->next)
    {
      register size_t i;
      for (i = 0; i < l->idx; ++i)
	if (l->fns[i].flavor == ef_free)
	  return &l->fns[i];
      if (l->idx < sizeof(l->fns) / sizeof(l->fns[0]))
	return &l->fns[l->idx++];
    }

  l = (struct exit_function_list *) malloc(sizeof(struct exit_function_list));
  if (l == NULL)
    return NULL;
  l->next = __exit_funcs;
  __exit_funcs = l;

  l->idx = 1;
  return &l->fns[0];
}
#endif


/* Convert a string to a double.  */
double atof (const char *nptr)
{
  return(strtod(nptr, (char **) NULL));
}


/* Convert a string to an int.  */
int atoi (const char *nptr)
{
  return((int) strtol(nptr, (char **) NULL, 10));
}


/* Convert a string to a long int.  */
long int atol (const char *nptr)
{
  return(strtol(nptr, (char **) NULL, 10));
}


/* Perform a binary search for KEY in BASE which has NMEMB elements
   of SIZE bytes each.  The comparisons are done by (*COMPAR)().  */
PTR bsearch ( const PTR key, const PTR base, size_t nmemb, size_t size,
              int (*compar)(const PTR, const PTR))
{
  register size_t l, u, idx;
  register const PTR p;
  register int comparison;

  l = 0;
  u = nmemb;
  while (l < u)
    {
      idx = (l + u) / 2;
      p = (PTR) (((const char *) base) + (idx * size));
      comparison = (*compar)(key, p);
      if (comparison < 0)
	u = idx;
      else if (comparison > 0)
	l = idx + 1;
      else
	return (PTR) p;
    }

  return NULL;
}


#ifdef	HAVE_GNU_LD
const struct
  {
    size_t n;
    void EXFUN((*fn[1]), (NOARGS));
  } __libc_atexit;
#endif


#if 0
   Ausgeblendet. CWK

/* Call all functions registered with `atexit' and `on_exit',
   in the reverse of the order in which they were registered
   perform stdio cleanup, and terminate program execution with STATUS.  */


void exit (int status)
{
  register const struct exit_function_list *l;

  for (l = __exit_funcs; l != NULL; l = l->next)
    {
      register size_t i = l->idx;
      while (i-- > 0)
	{
	  const struct exit_function *const f = &l->fns[i];
	  switch (f->flavor)
	    {
	    case ef_free:
	      break;
	    case ef_on:
	      (*f->func.on.fn)(status, f->func.on.arg);
	      break;
	    case ef_at:
	      (*f->func.at)();
	      break;
	    }
	}
    }

#ifdef	HAVE_GNU_LD
  {
    void EXFUN((*const *fn), (NOARGS));
    for (fn = __libc_atexit.fn; *fn != NULL; ++fn)
      (**fn) ();
  }
#else
  {
    extern void _cleanup (void);
    _cleanup();
  }
#endif

  _exit(status);
}


#ifndef	_EXIT_H

struct exit_function {
    enum { ef_free, ef_on, ef_at } flavor;	/* `ef_free' MUST be zero!  */
    union
      {
	void (*at)(void);
	struct
	  {
	    void EXFUN((*fn), (int status, PTR arg));
	    PTR arg;
	  } on;
      } func;
};

struct exit_function_list {
    struct exit_function_list *next;
    size_t idx;
    struct exit_function fns[32];
};

extern struct exit_function_list *__exit_funcs;

extern struct exit_function *EXFUN(__new_exitfn, (NOARGS));

#endif	/* exit.h  */
#endif  /*CWK*/


/* Return the absolute value of I.  */


long int labs (long int i)
{
  return(i < 0 ? -i : i);
}


/*
 * Copyright (c) 1990 Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/* Return the `ldiv_t' representation of NUMER over DENOM.  */



ldiv_t ldiv (long int numer, long int denom)
{
  ldiv_t result;

  result.quot = numer / denom;
  result.rem = numer % denom;

  /* The ANSI standard says that |QUOT| <= |NUMER / DENOM|, where
     NUMER / DENOM is to be computed in infinite precision.  In
     other words, we should always truncate the quotient towards
     zero, never -infinity.  Machine division and remainer may
     work either way when one or both of NUMER or DENOM is
     negative.  If only one is negative and QUOT has been
     truncated towards -infinity, REM will have the same sign as
     DENOM and the opposite sign of NUMER; if both are negative
     and QUOT has been truncated towards -infinity, REM will be
     positive (will have the opposite sign of NUMER).  These are
     considered `wrong'.  If both are NUM and DENOM are positive,
     RESULT will always be positive.  This all boils down to: if
     NUMER >= 0, but REM < 0, we got the wrong answer.  In that
     case, to get the right answer, add 1 to QUOT and subtract
     DENOM from REM.  */

  if (numer >= 0 && result.rem < 0) {
      ++result.quot;
      result.rem -= denom;
  }
  return result;
}


/* msort -- an alternative to qsort, with an identical interface.
   Copyright (C) 1992 Free Software Foundation, Inc.
   Written by Mike Haertel, September 1988. */

#define MEMCPY(dst, src, s) \
  ((s) == sizeof (int) \
   ? (*(int *) (dst) = *(int *) (src), (dst)) \
   : memcpy (dst, src, s))



static void msort_with_tmp ( PTR b, size_t n, size_t s,
                             int (cmp)(PTR, PTR), char *t)
{
  char *tmp;
  char *b1, *b2;
  size_t n1, n2;

  if (n <= 1)
    return;

  n1 = n / 2;
  n2 = n - n1;
  b1 = b;
  b2 = (char *) b + (n1 * s);

  msort_with_tmp (b1, n1, s, cmp, t);
  msort_with_tmp (b2, n2, s, cmp, t);

  tmp = t;

  while (n1 > 0 && n2 > 0) {
      if ((*cmp) (b1, b2) <= 0) {
          MEMCPY( tmp, b1, s );
	  b1 += s;
	  --n1;
	}
      else {
          MEMCPY( tmp, b2, s );
	  b2 += s;
	  --n2;
	}
      tmp += s;
    }
  if (n1 > 0) MEMCPY (tmp, b1, n1 * s);
  MEMCPY((int *)b, t, (n - n2) * s);
}


#if 0         /*CWK*/
int on_exit ( void (*func)(int status, PTR arg), PTR arg)
{
  struct exit_function *new = __new_exitfn();

  if (new == NULL)
    return -1;

  new->flavor = ef_on;
  new->func.on.fn = func;
  new->func.on.arg = arg;
  return 0;
}
#endif


/* Byte-wise swap two items of size SIZE. */
#define SWAP(a, b, size)						      \
  do									      \
    {									      \
      register size_t __size = (size);					      \
      register char *__a = (a), *__b = (b);				      \
      do								      \
	{								      \
	  char __tmp = *__a;						      \
	  *__a++ = *__b;						      \
	  *__b++ = __tmp;						      \
	} while (--__size > 0);						      \
    } while (0)


/* Discontinue quicksort algorithm when partition gets below this size.
   This particular magic number was chosen to work best on a Sun 4/260. */

#define MAX_THRESH 4

/* Stack node declarations used to store unfulfilled partition obligations. */

typedef struct {
    char *lo;
    char *hi;
} stack_node;

/* The next 4 #defines implement a very fast in-line stack abstraction. */

#define STACK_SIZE	(8 * sizeof(unsigned long int))
#define PUSH(low, high)	((void) ((top->lo = (low)), (top->hi = (high)), ++top))
#define	POP(low, high)	((void) (--top, (low = top->lo), (high = top->hi)))
#define	STACK_NOT_EMPTY	(stack < top)                


/* Order size using quicksort.  This implementation incorporates
   four optimizations discussed in Sedgewick:

   1. Non-recursive, using an explicit stack of pointer that store the 
      next array partition to sort.  To save time, this maximum amount 
      of space required to store an array of MAX_INT is allocated on the 
      stack.  Assuming a 32-bit integer, this needs only 32 * 
      sizeof(stack_node) == 136 bits.  Pretty cheap, actually.

   2. Chose the pivot element using a median-of-three decision tree.
      This reduces the probability of selecting a bad pivot value and 
      eliminates certain extraneous comparisons.

   3. Only quicksorts TOTAL_ELEMS / MAX_THRESH partitions, leaving
      insertion sort to order the MAX_THRESH items within each partition.  
      This is a big win, since insertion sort is faster for small, mostly
      sorted array segements.

   4. The larger of the two sub-partitions is always pushed onto the
      stack first, with the algorithm then concentrating on the
      smaller partition.  This *guarantees* no more than log (n)
      stack size is needed (actually O(1) in this case)!  */


void _quicksort ( PTR pbase, size_t total_elems, size_t size,
                  int (*cmp)(      PTR,       PTR))
{
  register char *base_ptr = (char *) pbase;

  /* Allocating SIZE bytes for a pivot buffer facilitates a better
     algorithm below since we can do comparisons directly on the pivot. */

  /*char *pivot_buffer = (char *) __alloca (size); CWK*/
  char *pivot_buffer;

  size_t max_thresh = MAX_THRESH * size;

  if (total_elems == 0)
    /* Avoid lossage with unsigned arithmetic below.  */
    return;

  /*asm("pshg epp,spp");  /* freeze private heap CWK */ 

  pivot_buffer = (char *) malloc (size); /*CWK*/

  if (total_elems > MAX_THRESH)
    {
      char *lo = base_ptr;
      char *hi = &lo[size * (total_elems - 1)];
      /* Largest size needed for 32-bit int!!! */
      stack_node stack[STACK_SIZE];
      stack_node *top = stack + 1;

      while (STACK_NOT_EMPTY)
        {
          char *left_ptr;
          char *right_ptr;

	  char *pivot = pivot_buffer;

	  /* Select median value from among LO, MID, and HI. Rearrange
	     LO and HI so the three values are sorted. This lowers the 
	     probability of picking a pathological pivot value and 
	     skips a comparison for both the LEFT_PTR and RIGHT_PTR. */

	  char *mid = lo + size * ((hi - lo) / size >> 1);

	  if ((*cmp)((PTR) mid, (PTR) lo) < 0)
	    SWAP(mid, lo, size);
	  if ((*cmp)((PTR) hi, (PTR) mid) < 0)
	    SWAP(mid, hi, size);
	  else 
	    goto jump_over;
	  if ((*cmp)((PTR) mid, (PTR) lo) < 0)
	    SWAP(mid, lo, size);
	jump_over:;
	  MEMCPY(pivot, mid, size);
	  pivot = pivot_buffer;

	  left_ptr  = lo + size;
	  right_ptr = hi - size; 

	  /* Here's the famous ``collapse the walls'' section of quicksort.  
	     Gotta like those tight inner loops!  They are the main reason 
	     that this algorithm runs much faster than others. */
	  do 
	    {
	      while ((*cmp)((PTR) left_ptr, (PTR) pivot) < 0)
		left_ptr += size;

	      while ((*cmp)((PTR) pivot, (PTR) right_ptr) < 0)
		right_ptr -= size;

	      if (left_ptr < right_ptr) 
		{
		  SWAP(left_ptr, right_ptr, size);
		  left_ptr += size;
		  right_ptr -= size;
		}
	      else if (left_ptr == right_ptr) 
		{
		  left_ptr += size;
		  right_ptr -= size;
		  break;
		}
	    } 
	  while (left_ptr <= right_ptr);

          /* Set up pointers for next iteration.  First determine whether
             left and right partitions are below the threshold size.  If so, 
             ignore one or both.  Otherwise, push the larger partition's
             bounds on the stack and continue sorting the smaller one. */

          if ((size_t) (right_ptr - lo) <= max_thresh)
            {
              if ((size_t) (hi - left_ptr) <= max_thresh)
		/* Ignore both small partitions. */
                POP(lo, hi); 
              else
		/* Ignore small left partition. */  
                lo = left_ptr;
            }
          else if ((size_t) (hi - left_ptr) <= max_thresh)
	    /* Ignore small right partition. */
            hi = right_ptr;
          else if ((right_ptr - lo) > (hi - left_ptr))
            {                   
	      /* Push larger left partition indices. */
              PUSH(lo, right_ptr);
              lo = left_ptr;
            }
          else
            {                   
	      /* Push larger right partition indices. */
              PUSH(left_ptr, hi);
              hi = right_ptr;
            }
        }
    }

  /* Once the BASE_PTR array is partially sorted by quicksort the rest
     is completely sorted using insertion sort, since this is efficient 
     for partitions below MAX_THRESH size. BASE_PTR points to the beginning 
     of the array to sort, and END_PTR points at the very last element in
     the array (*not* one beyond it!). */

#define mymin(x, y) ((x) < (y) ? (x) : (y))

  {
    char *const end_ptr = &base_ptr[size * (total_elems - 1)];
    char *tmp_ptr = base_ptr;
    char *thresh = mymin(end_ptr, base_ptr + max_thresh);
    register char *run_ptr;

    /* Find smallest element in first threshold and place it at the
       array's beginning.  This is the smallest array element,
       and the operation speeds up insertion sort's inner loop. */

    for (run_ptr = tmp_ptr + size; run_ptr <= thresh; run_ptr += size)
      if ((*cmp)((PTR) run_ptr, (PTR) tmp_ptr) < 0)
        tmp_ptr = run_ptr;

    if (tmp_ptr != base_ptr)
      SWAP(tmp_ptr, base_ptr, size);

    /* Insertion sort, running from left-hand-side up to right-hand-side.  */

    run_ptr = base_ptr + size;
    while ((run_ptr += size) <= end_ptr)
      {
	tmp_ptr = run_ptr - size;
	while ((*cmp)((PTR) run_ptr, (PTR) tmp_ptr) < 0)
	  tmp_ptr -= size;

	tmp_ptr += size;
        if (tmp_ptr != run_ptr)
          {
            char *trav;

	    trav = run_ptr + size;
	    while (--trav >= run_ptr)
              {
                char c = *trav;
                char *hi, *lo;

                for (hi = lo = trav; (lo -= size) >= tmp_ptr; hi = lo)
                  *hi = *lo;
                *hi = c;
              }
          }
      }
  }
  /*asm(" popgn spp,epp\n");      /*unfreeze heap CWK */  
}


void qsort ( PTR b, size_t n, size_t s, int (cmp)(PTR, PTR) )
{
#if 0
  ++++++ Das hier klappt zwar, aber ist wesentlich
  ++++++ ineffizienter auf der SB-PRAM. Daher auskommentiert.
  ++++++ CWK 960229
  const size_t size = n * s;
      char *tmp;
      /*asm("pshg epp,spp\n");    /*CWK:  freeze private heap*/

  if (size < 1024)
    /* The temporary array is small, so put it on the stack.  */
    msort_with_tmp (b, n, s, cmp, malloc (size));
  else
    {
      /* It's somewhat large, so malloc it.  */
      int save = errno;
      tmp = malloc (size);
      if (tmp == NULL) {
	  /* Couldn't get space, so use the slower algorithm
	     that doesn't need a temporary array.  */
#endif
	  _quicksort (b, n, s, cmp);
#if 0
	}
      else
	{
	  msort_with_tmp (b, n, s, cmp, tmp);
	  /*free (tmp);    CWK*/
	}
      errno = save;
      /*asm("popgn spp,epp\n");  /*CWK: unfreeze heap*/
    }
#endif
}


/* Convert NPTR to a double.  If ENDPTR is not NULL, a pointer to the
   character after the last one used in the number is put in *ENDPTR.  */
double strtod (const char *nptr, char **endptr)
{
  const char *s;
  short int sign;
#if 0           /*CWK*/
  wchar_t decimal;	/* Decimal point character.  */
#endif

  /* The number so far.  */
  int num;     /*CWK: vorher double, aber klappt nicht. lieber ungenau als gar nix.*/
  double dnum;  /*CWK*/
  int got_dot;		/* Found a decimal point.  */
  int got_digit;	/* Seen any digits.  */

  /* The exponent of the number.  */
  long int exponent;

  if (nptr == NULL) {
      errno = EINVAL;
      goto noconv;
  }

#if 0
  /* Figure out the decimal point character.  */
  if (mbtowc(&decimal, _numeric_info->decimal_point, 1) <= 0)
    decimal = (wchar_t) *_numeric_info->decimal_point;
#endif

  s = nptr;

  /* Eat whitespace.  */
  while (isspace(*s))    ++s;

  /* Get the sign.  */
  sign = *s == '-' ? -1 : 1;
  if (*s == '-' || *s == '+')
    ++s;

  num = 0;
  got_dot = 0;
  got_digit = 0;
  exponent = 0;
  for (;; ++s)
    {
      if (isdigit (*s))
	{
	  got_digit = 1;

#if 0    /*mist, das bloede ding klappt nicht. also weg damit.  CWK */
	  /* Make sure that multiplication by 10 will not overflow.  */
	  if (num > DBL_MAX * 0.1) {
	    /* The value of the digit doesn't matter, since we have already
	       gotten as many digits as can be represented in a `double'.
	       This doesn't necessarily mean the result will overflow.
	       The exponent may reduce it to within range.

	       We just need to record that there was another
	       digit so that we can multiply by 10 later.  */
	    ++exponent;
            puts("huge\n");   /*CWK test*/
          }
	  else {
#endif
	    num = num*10 + (*s - '0');
          /*}*/
	  /* Keep track of the number of digits after the decimal point.
	     If we just divided by 10 here, we would lose precision.  */
	  if (got_dot)
	    --exponent;
	}
#if 0             /*CWK*/
      else if (!got_dot && (wchar_t) *s == decimal)
#endif
      else if (!got_dot &&  *s == '.')
	/* Record that we have found the decimal point.  */
	got_dot = 1;
      else
	/* Any other character terminates the number.  */
	break;
    }

  if (!got_digit)
    goto noconv;

  if (tolower(*s) == 'e') {
      /* Get the exponent specified after the `e' or `E'.  */
      int save = errno;
      char *end;
      long int exp;

      errno = 0;
      ++s;
      exp = strtol(s, &end, 10);
      if (errno == ERANGE)
	{
	  /* The exponent overflowed a `long int'.  It is probably a safe
	     assumption that an exponent that cannot be represented by
	     a `long int' exceeds the limits of a `double'.  */
	  if (endptr != NULL)
	    *endptr = end;
	  if (exp < 0)
	    goto underflow;
	  else
	    goto overflow;
	}
      else if (end == s)
	/* There was no exponent.  Reset END to point to
	   the 'e' or 'E', so *ENDPTR will be set there.  */
	end = (char *) s - 1;
      errno = save;
      s = end;
      exponent += exp;
  }

  if (endptr != NULL)
    *endptr = (char *) s;

  if (num == 0)
    return 0.0;

  /* Multiply NUM by 10 to the EXPONENT power,
     checking for overflow and underflow.  */
#if 0
  if (exponent < 0)
    {
      if ((double)num < DBL_MIN * pow(10.0, (double) -exponent))
	goto underflow;
    }
  else if (exponent > 0)
    {
      if ((double)num > DBL_MAX * pow(10.0, (double) -exponent))
	goto overflow;
    }
#endif
  /*pprintf("%d\n", itento(-exponent));*/
  if (exponent >0) dnum = (itof(num)) * (float)itento(exponent);
  if (exponent <0) dnum = (itof(num)) / (float)itento(-exponent);
  return dnum * itof(sign);

 overflow:
  /* Return an overflow error.  */
  puts("overflow!\n");   /*CWK test*/
  errno = ERANGE;
  return HUGE_VAL * sign;

 underflow:
  /* Return an underflow error.  */
  puts("underflow!\n");   /*CWK test*/
  if (endptr != NULL)
    *endptr = (char *) nptr;
  errno = ERANGE;
  return 0.0;

 noconv:
  /* There was no number.  */
  puts("noconv!\n");   /*CWK test*/
  if (endptr != NULL)
    *endptr = (char *) nptr;
  return 0.0;
}


/*strtol: */

/* Convert NPTR to an `unsigned long int' or `long int' in base BASE.
   If BASE is 0 the base is determined by the presence of a leading
   zero, indicating octal or a leading "0x" or "0X", indicating hexadecimal.
   If BASE is < 2 or > 36, it is reset to 10.
   If ENDPTR is not NULL, a pointer to the character after the last
   one converted is stored in *ENDPTR.  */


long int strtol ( const char *nptr, char **endptr, int base)
{
  int negative;
  register unsigned long int cutoff;
  register unsigned int cutlim;
  register unsigned long int i;
  register const char *s;
  register unsigned char c;
  const char *save;
  int overflow;

  if (base < 0 || base == 1 || base > 36)
    base = 10;

  s = nptr;

  /* Skip white space.  */
  while (isspace(*s))
    ++s;
  if (*s == '\0')
    goto noconv;

  /* Check for a sign.  */
  if (*s == '-')
    {
      negative = 1;
      ++s;
    }
  else if (*s == '+') {
      negative = 0;
      ++s;
    }
  else
    negative = 0;

  if (base == 16 && s[0] == '0' && toupper(s[1]) == 'X')
    s += 2;

  /* If BASE is zero, figure it out ourselves.  */
  if (base == 0)
    if (*s == '0')
      {
	if (toupper(s[1]) == 'X')
	  {
	    s += 2;
	    base = 16;
	  }
	else
	  base = 8;
      }
    else
      base = 10;

  /* Save the pointer so we can check later if anything happened.  */
  save = s;

  cutoff = ULONG_MAX / (unsigned long int) base;
  cutlim = ULONG_MAX % (unsigned long int) base;

  overflow = 0;
  i = 0;
  for (c = *s; c != '\0'; c = *++s)
    {
      if (isdigit(c))
	c -= '0';
      else if (isalpha(c))
	c = toupper(c) - 'A' + 10;
      else
	break;
      if (c >= base)
	break;
      /* Check for overflow.  */
      if (i > cutoff || (i == cutoff && c > cutlim))
	overflow = 1;
      else
	{
	  i *= (unsigned long int) base;
	  i += c;
	}
    }

  /* Check if anything actually happened.  */
  if (s == save)
    goto noconv;

  /* Store in ENDPTR the address of one character
     past the last character we converted.  */
  if (endptr != NULL)
    *endptr = (char *) s;

  /* Check for a value that is within the range of
     `unsigned long int', but outside the range of `long int'.  */
  if (i > (negative ? - LONG_MIN : LONG_MAX))
    overflow = 1;

  if (overflow)
    {
      errno = ERANGE;
      return negative ? LONG_MIN : LONG_MAX;
    }

  /* Return the result of the appropriate sign.  */
  return (negative ? - (int)i : (int)i);

 noconv:
  /* There was no number to convert.  */
  if (endptr != NULL)
    *endptr = (char *) nptr;
  return 0L;
}


/* strtoul: */

/* Convert NPTR to an `unsigned long int' or `long int' in base BASE.
   If BASE is 0 the base is determined by the presence of a leading
   zero, indicating octal or a leading "0x" or "0X", indicating hexadecimal.
   If BASE is < 2 or > 36, it is reset to 10.
   If ENDPTR is not NULL, a pointer to the character after the last
   one converted is stored in *ENDPTR.  */

unsigned long int strtoul ( const char *nptr, char **endptr, int base)
{
  int negative;
  register unsigned long int cutoff;
  register unsigned int cutlim;
  register unsigned long int i;
  register const char *s;
  register unsigned char c;
  const char *save;
  int overflow;

  if (base < 0 || base == 1 || base > 36)
    base = 10;

  s = nptr;

  /* Skip white space.  */
  while (isspace(*s))
    ++s;
  if (*s == '\0')
    goto noconv;

  /* Check for a sign.  */
  if (*s == '-')
    {
      negative = 1;
      ++s;
    }
  else if (*s == '+') {
      negative = 0;
      ++s;
    }
  else
    negative = 0;

  if (base == 16 && s[0] == '0' && toupper(s[1]) == 'X')
    s += 2;

  /* If BASE is zero, figure it out ourselves.  */
  if (base == 0)
    if (*s == '0')
      {
	if (toupper(s[1]) == 'X')
	  {
	    s += 2;
	    base = 16;
	  }
	else
	  base = 8;
      }
    else
      base = 10;

  /* Save the pointer so we can check later if anything happened.  */
  save = s;

  cutoff = ULONG_MAX / (unsigned long int) base;
  cutlim = ULONG_MAX % (unsigned long int) base;

  overflow = 0;
  i = 0;
  for (c = *s; c != '\0'; c = *++s)
    {
      if (isdigit(c))
	c -= '0';
      else if (isalpha(c))
	c = toupper(c) - 'A' + 10;
      else
	break;
      if (c >= base)
	break;
      /* Check for overflow.  */
      if (i > cutoff || (i == cutoff && c > cutlim))
	overflow = 1;
      else
	{
	  i *= (unsigned long int) base;
	  i += c;
	}
    }

  /* Check if anything actually happened.  */
  if (s == save)
    goto noconv;

  /* Store in ENDPTR the address of one character
     past the last character we converted.  */
  if (endptr != NULL)
    *endptr = (char *) s;

  if (overflow)
    {
      errno = ERANGE;
      return ULONG_MAX;
    }

  /* Return the result of the appropriate sign.  */
  return (negative ? - (int)i : (int)i);

 noconv:
  /* There was no number to convert.  */
  if (endptr != NULL)
    *endptr = (char *) nptr;
  return 0L;
}

