/* fcc.c  Source fuer fcc - Driver  (c)29.11.1994 C.W. Kessler */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "fcc.h"

char *prepr, *compil, *adapt, *prass, *plink;
char *compopts, *linkopts = "", *prepropts = "", *assopts = "";
char *Umlenkung = "";
char **src, *tolink = "";
int srcs = 0;
int Eflag=0;
int Sflag=0;
int cflag=0;
int vflag=0;

char *append(s1, s2)
  char *s1, *s2;
{
  char *s = (char *) malloc(strlen(s1) + strlen(s2) + 2);
  sprintf(s,"%s %s", s1, s2);
  return s;
}

void doargs(argc,argv)
 int argc;
 char *argv[];
{                     /* setze src, compopts, linkopts */
 char *s;
 int i;
 src = (char **) malloc(20);
 compopts = "";
 for (i=1; i<argc; i++) {
   s = argv[i];
   if (s[0]=='-') {  /*Option*/
     switch( s[1] ) {  /*unterscheide Compileroptionen von anderen*/
       case 'C':
       case 'D':
       case 'I':
       case 'U': /*Pr"aprozessoroptionen:*/
                 prepropts = append(prepropts, s);
                 break; 
       case 'E': Eflag = 1;
                 break;
       case 'S': Sflag = 1;   /*behalte .s-Files*/
                 break;
       case 'o': /* -o outfilename: */
                 linkopts = append(linkopts, s);
                 s = argv[++i];
                 /* fall through: */
       case 'l': /* -lm Linkoptionen */
                 linkopts = append(linkopts, s);
                 break;
       case 'c': cflag = 1;
                 break;
       case 'v': vflag++;
                 break;
       case 'W': switch( s[2] ) {
                  case 'p': prepropts = append(prepropts, &s[3]); break;
                  case 'a': assopts = append(assopts, &s[3]); break;
                  case 'l': linkopts = append(linkopts, &s[3]); break;
                  default:  compopts = append(compopts, &s[3]); break;
                 }
       default:  compopts = append(compopts, s);
                 break;
     }
   }
   else                /* kein - */
   if (s[0]=='>' || s[0]=='2'&& s[1]=='>') {  /*Umlenkung auf File*/
      Umlenkung = s;
      if (s[1]=='>')   /* trifft 2> und >> */
         if (isalpha(s[2])||ispunct(s[2])||s[2]=='/')  /*Pfad folgt direkt*/
            ;  /*Umlenkung bleibt so*/
         else 
            Umlenkung = append(s, argv[++i]);
      else
         if (isalpha(s[1])||ispunct(s[1])||s[1]=='/')  /*Pfad folgt direkt*/
            ;  /*Umlenkung bleibt so*/
         else
            Umlenkung = append(s, argv[++i]);
   }
   else {                      /*Sourcefile*/    
     int n = strlen(s);
     if (s[n-2]=='.' && s[n-1]=='c') {
        s[n-2]='\0';
        src[srcs++] = s;
     } else
     if (s[n-2]=='.' && s[n-1]=='o')
        tolink = append( tolink, s ); 
     else printf("Useless parameter: %s\n", s);
   }
 }
}

char *linkfiles( srcfile, srces )
  char **srcfile;
  int srces;
{
  int i;
  char *ret = "";
  for (i=0; i<srces; i++) {
    char *lnkname = (char *) malloc(50);
    sprintf( lnkname, " %s.o", srcfile[i] );
    ret = append( ret, lnkname );
  }
  return append( tolink, ret );
}


main(argc,argv)
 int argc;
 char *argv[];
{
 int i, x;
 char *source;
 doargs(argc, argv);   /* setze src, compopts, linkopts */
 prepr = (char *)malloc(256);
 compil = (char *)malloc(256);
 adapt = (char *)malloc(256);
 prass = (char *)malloc(256);
 if (vflag) {
  printf("\nfcc Fork95 Compiler V. 1.0 (Nov.1994) by C.W.Kessler");
  printf("\n    please report bugs to kessler@cs.uni-sb.de\n");
 }
 /*if (!system(0)) { printf("system error, sorry\n"); exit(1); }*/
 for (i=0; i<srcs; i++) {
  source = src[i];
  if (Eflag)
   sprintf(prepr, "%s %s -o %s.i %s.c",
                  thepreprocessor, prepropts, source, source);
  else
   sprintf(prepr, "%s %s -o %s.f %s.c", 
                  thepreprocessor, prepropts, source, source);
  if (vflag) printf("%s\n", prepr);
  if (vflag<2) if ((x=system(prepr))!=0) exit(x);
  if (Eflag) exit(0);  /*nur Praeprozessor*/
  if (!Umlenkung[0])
    sprintf(compil, "%s %s %s.f >%s.s; rm %s.f",
                    thecompiler, compopts, source, source, source );
  else
    sprintf(compil, "%s %s %s.f %s; rm %s.f",
                    thecompiler, compopts, source, Umlenkung, source );
  if (vflag) printf("%s\n", compil);
  if (vflag<2) if ((x=system(compil))!=0) exit(x);
  sprintf(adapt,"%s -I%s -x c -o %s.i %s.s",
            thepreprocessor, thelibdir, source, source);
  if (vflag) printf("%s\n", adapt);
  if (vflag<2) if ((x=system(adapt))!=0) exit(x);
  if (!Sflag) {
    sprintf(adapt,"rm %s.s", source);
    if (vflag) printf("%s\n", adapt);
    if (vflag<2) if ((x=system(adapt))!=0) exit(x);
  }
  sprintf(prass,"%s %s -o %s.o %s.i; rm %s.i",
                theassembler, assopts, source, source, source);
  if (vflag) printf("%s\n", prass);
  if (vflag<2) if ((x=system(prass))!=0) exit(x);
 }
 if (cflag) exit(0);    /* Nicht linken. */
 {/*else*/
  char *lnks;
  plink = (char *)malloc(512);
  lnks = linkfiles(src,srcs);
  if (!lnks) exit(1);
  
  sprintf(plink,"%s %s %s %s/forklib2.o \
   %s/stdlib.o %s/graphic.o %s/string.o %s/ctype.o %s/io.o %s/print.o %s/async.o %s/join.o \
   %s/math.o %s", 
                 thelinker, linkopts, lnks, thelibdir,               thelibdir,
   thelibdir, thelibdir, thelibdir, thelibdir, thelibdir, thelibdir, thelibdir, thelibdir, 
   Umlenkung);
  if (vflag) printf("%s\n", plink);
  if (vflag<2) { x=system(plink); if (x!=0) exit(x); }
  /*
  sprintf(plink,"rm %s", lnks);
  if (vflag) printf("%s\n", plink);
  if (vflag<2) system(plink);
  */
 }
 return(0);
}
