/*
 *  $Id: dmpiatom.h,v 1.26 1994/06/08 22:29:22 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   dmpiatom.h                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* Atomic types */

#ifndef _DMPIATOM_INCLUDE
#define _DMPIATOM_INCLUDE

/*****************************************************************************
*                           MPI ATOMIC DATA STRUCTURES                       *
*****************************************************************************/

/*****************************************************************************
*  We place "cookies into the data structures to improve error detection and *
*  reporting of invalid objects.  In order to make this flexible, the        *
*  cookies are defined as macros.
*****************************************************************************/
#define MPIR_COOKIE unsigned long cookie;
/* #define MPIR_COOKIE */
/****************************************************************************/

/* insure that this is at least 32 bits */
typedef unsigned long MPIR_uint32;

typedef struct _MPIR_HBT_node {
  void  far *value;
  Int   keyval;
//  short balance;
  Int balance;
  struct _MPIR_HBT_node far *left;
  struct _MPIR_HBT_node far *right;
} MPIR_HBT_node;

typedef MPIR_HBT_node far *LPMPIR_HBT_node;
typedef LPMPIR_HBT_node far *LPPMPIR_HBT_node;

typedef struct _MPIR_HBT {
  unsigned Int   height;
  Int            ref_count;
  MPIR_HBT_node far *root;
} MPIR_HBT;

typedef MPIR_HBT far *LPMPIR_HBT;
typedef LPMPIR_HBT far *LPPMPIR_HBT;

typedef struct  {
//  Int  (*copy_fn)(MPI_Comm far *, Int far *, void far *, void far *,
//                  LPPVOID, Int far *);
//  Int  (*delete_fn)(MPI_Comm, Int, void far *, void far *);
  MPI_Copy_function		*copy_fn;
  MPI_Delete_function	*delete_fn;
  void  far *extra_state;
  Int    ref_count;
  Int    permanent;             /* Used to mark the permanent attributes of
				   MPI_COMM_WORLD */
} MPIR_Attr_key;

typedef struct {
  MPIR_COOKIE
  Int nnodes;
  Int nedges;
  Int far *index;
  Int far *edges;
} MPIR_GRAPH_TOPOLOGY;

typedef struct {
  MPIR_COOKIE
  Int nnodes;
  Int ndims;
  Int far *dims;
  Int far *periods;
  Int far *position;
} MPIR_CART_TOPOLOGY;

typedef struct {
  Int type;
  union {
    MPIR_GRAPH_TOPOLOGY  graph;
    MPIR_CART_TOPOLOGY   cart;
  } tag;
} MPIR_TOPOLOGY;

struct MPIR_GROUP {
    MPIR_COOKIE             /* Cookie to help detect valid item */
    Int np;		    /* Number of processes in group */
    Int local_rank;         /* My rank in the group (if I belong) */
    Int ref_count;          /* Number of references to this group */
    Int N2_next;            /* Next power of 2 from np */
    Int N2_prev;            /* Previous power of 2 from np */
    Int permanent;          /* Permanent group */
    Int far *lrank_to_grank;    /* Mapping from local to "global" ranks */
    Int far *set_mark;          /* Used for set marking/manipulation on groups */
};

typedef unsigned long MPIR_CONTEXT;
#define  MPIR_CONTEXT_TYPE MPI_UNSIGNED_LONG

#define  MPIR_WORLD_PT2PT_CONTEXT 0
#define  MPIR_WORLD_COLL_CONTEXT  1
#define  MPIR_SELF_PT2PT_CONTEXT  2
#define  MPIR_SELF_COLL_CONTEXT   3
#define  MPIR_FIRST_FREE_CONTEXT  4

typedef enum { MPIR_INTRA=0, MPIR_INTER } MPIR_COMM_TYPE;

struct MPIR_COMMUNICATOR {
    MPIR_COOKIE                   /* Cookie to help detect valid item */
    MPIR_COMM_TYPE comm_type;	  /* inter or intra */
    MPI_Group     group;	  /* group associated with communicator */
    MPI_Group     local_group;   /* local group */
    MPI_Comm      comm_coll; /* communicator for collective ops */

    Int            ref_count;     /* number of references to communicator */
    MPIR_CONTEXT   send_context;  /* context to send messages */
    MPIR_CONTEXT   recv_context;  /* context to recv messages */
    void          far *comm_cache;	  /* Hook for communicator cache */
    MPIR_HBT      far *attr_cache;    /* Hook for attribute cache */
    MPIR_TOPOLOGY  topology;      /* Topology information */
//#ifdef __STDC__
//    void (*error_handler)();
// WIN : better
    MPI_Errhandler error_handler;
/* Until we get the stdargs stuff straight */
/*     void (*error_handler)(MPI_Comm,int *,...); */
/*#else
    void (*error_handler)();
#endif */
    Int            permanent;      /* Is this a permanent object? */
};

typedef enum {
  MPIR_NO = 0, MPIR_YES
} MPIR_BOOL;

typedef enum {
    MPIR_INT, MPIR_FLOAT, MPIR_DOUBLE, MPIR_COMPLEX, MPIR_LONG, MPIR_SHORT,
    MPIR_CHAR, MPIR_BYTE, MPIR_UCHAR, MPIR_USHORT, MPIR_ULONG, MPIR_UINT,
    MPIR_CONTIG, MPIR_VECTOR, MPIR_HVECTOR, MPIR_INDEXED,
    MPIR_HINDEXED, MPIR_STRUCT, MPIR_DOUBLE_COMPLEX, MPIR_PACKED, 
	MPIR_UB, MPIR_LB, MPIR_LONGDOUBLE 
} MPIR_NODETYPE;

/* These are used by some of the datatype routines */
#ifndef MPIR_TRUE
#define MPIR_TRUE  1
#define MPIR_FALSE 0
#endif

#define MPIR_UNMARKED 0
#define MPIR_MARKED   1

#include "mpi_bc.h"
#endif



