/*
 *  $Id: sbcnst.h,v 1.6 1994/06/07 21:30:27 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   sbcnst.h                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* %W% %G% */
#ifndef _SBCNST
#define _SBCNST 

/* This is the allocation unit. */
typedef struct _sbialloc {
    struct _sbialloc far *next;
    Int              nbytes, nballoc;
    Int              nbinuse;
    } MPIR_SBiAlloc;

/* Blocks are linked together; they are (much) larger than this */
typedef struct {
    char far *next;
    } MPIR_SBblock;

/* Context for fixed-block allocator */
typedef struct {
    MPIR_SBiAlloc far *blocks;	         /* allocated storage */
    MPIR_SBblock  far *avail;             /* fixed blocks (of size sizeb) to provide */
    Int     nbfree, nballoc,     /* blocks free and in use */
            sizeb,               /* sizes in bytes */
            sizeincr;            /* # of blocks to allocate when more needed */
    } MPIR_SBHeader;

//#ifndef _SBCNSTDEF
//#if defined __STDC__
//extern void far *MPIR_SBinit( Int, Int, Int ), 
//             MPIR_SBfree( /* MPIR_SBHeader *, void * */ ), 
//             MPIR_SBiAllocate( /* MPIR_SBHeader *, int, int */), 
//            far *MPIR_SBalloc( /* MPIR_SBalloc * */ ), 
//             MPIR_SBPrealloc( /* MPIR_SBHeader *, int */ );

MPIR_SBHeader far *MPIR_SBinit( Int bsize, Int nb, Int nbincr);
void	MPIR_SBfree( MPIR_SBHeader far *sb, void far *ptr);
void	MPIR_SBiAllocate( MPIR_SBHeader far *sb, Int bsize, Int nb);
void far *	MPIR_SBalloc( MPIR_SBHeader far *sb);
void	MPIR_SBPrealloc( MPIR_SBHeader far *sb, Int nb);
void	MPIR_SBdestroy( MPIR_SBHeader far *sb);
void	MPIR_SBrelease( MPIR_SBHeader far *sb, void far *ptr);
void	MPIR_SBFlush( MPIR_SBHeader far *sb);
void	MPIR_SBDump( FILE *fp, MPIR_SBHeader far *sb);
void	MPIR_SBReleaseAvail( MPIR_SBHeader far *sb);


/* #else
extern void far *MPIR_SBinit(), MPIR_SBfree(), MPIR_SBiAllocate(), 
            far *MPIR_SBalloc(), MPIR_SBPrealloc(); */
//#endif
//#endif

#define SBinit BUGGG%
#define SBfree BUGGG%
#define SBiAllocate BUGGG%
#define SBalloc BUGGG%
#define SBPrealloc BUGGG%

/* Chameleon/PETSc includes memory tracing functions that can be used
   to track storage leaks.  */
#ifndef MALLOC
#if defined(DEVICE_CHAMELEON) && defined(MPIR_DEBUG_MEM)
#define MPI_MALLOC(a)    trmalloc((unsigned)(a),__LINE__,__FILE__)
#define MPI_CALLOC(a,b)  trcalloc((unsigned)(a),(unsigned)(b),__LINE__,__FILE__)
#define MPI_FREE(a)      trfree((char far *)(a),__LINE__,__FILE__)
#define MPI_NEW(a)    (a far *)MPI_MALLOC(sizeof(a))
/* Also replace the SB allocators so that we can get the trmalloc line/file
   tracing. */
#define MPIR_SBinit(a,b,c) ((void far *)(a))
#define MPIR_SBalloc(a)    trmalloc((unsigned)(a),__LINE__,__FILE__)
#define MPIR_SBfree(a,b)   trfree((char far **)(b),__LINE__,__FILE__)
#define MPIR_SBdestroy(a)
#else
#ifdef WIN31
#define MPI_MALLOC(a)    p4_shmalloc((unsigned long)(a))
#define MPI_CALLOC(a,b)  p4_shmalloc((unsigned long)(a) * (unsigned long)(b))
#define MPI_FREE(a)      p4_shfree((char far *)(a))
#define MPI_NEW(a)    (a far *)MPI_MALLOC(sizeof(a))
#else
#define MPI_MALLOC(a)    malloc((unsigned)(a))
#define MPI_CALLOC(a,b)  calloc((unsigned)(a),(unsigned)(b))
#define MPI_FREE(a)      free((char far *)(a))
#define MPI_NEW(a)    (a far *)MPI_MALLOC(sizeof(a))
#endif /*WIN31*/
#endif /*MPIR_DEBUG_MEM*/
#endif /*MALLOC*/

#endif
