
/***********************************************************************
*                                                                      *
*   p4_mon.h                                                           *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

struct p4_monitor {
    p4_lock_t mon_lock;
    struct p4_mon_queue far *qs;
};

typedef struct p4_monitor p4_monitor_t;


struct p4_mon_queue {
    Int count;
    p4_lock_t delay_lock;
};


struct p4_getsub_monitor {
    struct p4_monitor m;
    Int sub;
};

typedef struct p4_getsub_monitor p4_getsub_monitor_t;

#define p4_getsub(gs,s,max,nprocs) p4_getsubs(gs,s,max,nprocs,1)

struct p4_barrier_monitor {
    struct p4_monitor m;
};

typedef struct p4_barrier_monitor p4_barrier_monitor_t;

struct p4_askfor_monitor {
    struct p4_monitor m;
    Int pgdone;
    Int pbdone;
};

typedef struct p4_askfor_monitor p4_askfor_monitor_t;

