
/***********************************************************************
*                                                                      *
*   p4_args.c                                                          *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/*
 * p4_args.c   Code that looks at the arguments, recognizes any that are
 *             for p4, uses the arguments, and removes them from the
 *             command line args.
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "p4.h"
#include "p4_sys.h"

/* Macro used to see if an arg is not following the correct format. */
#define bad_arg(a)    ( ((a)==NULL) || ((*(a)) == '-') )

static char pgm[100];		/* Used to keep argv[0] for the usage cmd. */

static P4VOID print_version_info (void);
static P4VOID strip_out_args(LPPSTR argv, int far *argc, int far *c, int num);
static P4VOID usage(void);
              
int my_fatoi (char far *string)
{
// integer never longer than 6 but maybe there are spaces
    _fstrncpy (exportbuf, string, 100); 
    return atoi (exportbuf);
}


P4VOID process_args(int far *argc, LPPSTR argv)
{
    LPSTR  s;
    LPPSTR a;
    FILE *fp;
    char argbuf[100];
	int c;

    /* Put the name of the called program (according to the args) into pgm */
    s = _fstrrchr (*argv, (int)'\\');
    if (s)
		_fstrcpy((char far *)pgm, s + 1);
    else
		_fstrcpy((char far *)pgm, *argv);

    /* Set all command line flags (except procgroup) to their defaults */
    debug_level = 0;
    /* remote_debug_level = 0; */
    bm_outfile[0] = '\0';
    procgroup_file[0] = '\0';
    /* strcpy(local_domain, ""); */

    /* Move to last argument, so that we can go backwards. */
    a = &argv[*argc - 1];

    /*
     * Loop backwards through arguments, catching the ones that start with
     * '-'.  Backwards is more efficient when you are stripping things out.
     */
    for (c = (*argc); c > 1; c--, a--)
    {
		if (**a != '-')
		    continue;
	
		if (!_fstrcmp(*a, "-pg")      ||   !_fstrcmp(*a, "-pg")      ||
		    !_fstrcmp(*a, "-dbg")     ||   !_fstrcmp(*a, "-ssport")  ||
		    !_fstrcmp(*a, "-rdbg")    ||   !_fstrcmp(*a, "-gm")      ||
		    !_fstrcmp(*a, "-dmn")     ||   !_fstrcmp(*a, "-out")     ||
		    !_fstrcmp(*a, "-rout")    ||   !_fstrcmp(*a, "-log")     ||
		    !_fstrcmp(*a, "-norem")   ||   !_fstrcmp(*a, "-version") ||
		    !_fstrcmp(*a, "-help"))
		{
		    printf("Warning: %s should be -p4%s\n",*a,(*a)+1);
		}
	
	
		if (!_fstrcmp(*a, "-p4pg")  ||  !_fstrcmp(*a, "-pg"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
		    _fstrcpy((char far *)procgroup_file, a[1]);
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4dbg") ||  !_fstrcmp(*a, "-dbg"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
			_fstrcpy ((LPSTR)argbuf, a[1]);
		    debug_level = my_fatoi(argbuf);
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4ssport") ||  !_fstrcmp(*a, "-ssport"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
			_fstrcpy ((LPSTR)argbuf, a[1]);
		    /* sserver_port = my_fatoi(argbuf); */
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4rdbg") ||  !_fstrcmp(*a, "-rdbg"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
			_fstrcpy ((LPSTR)argbuf, a[1]);
		    /* remote_debug_level = my_fatoi(argbuf); */
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4gm") ||  !_fstrcmp(*a, "-gm"))
		{
		    if (bad_arg(a[1]))
				usage();        // doesn't come back
			_fstrcpy ((LPSTR)argbuf, a[1]);
		    globmemsize = my_fatoi(argbuf);
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4dmn") ||  !_fstrcmp(*a, "-dmn"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
		    /* _fstrcpy((LPSTR)local_domain, a[1]); */
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4out") ||  !_fstrcmp(*a, "-out"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
		    _fstrcpy((LPSTR)bm_outfile, a[1]);
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4rout") ||  !_fstrcmp(*a, "-rout"))
		{
		    if (bad_arg(a[1]))
				usage();  		// doesn't come back
		    /* _fstrcpy((LPSTR)rm_outfile_head, a[1]); */
		    strip_out_args(a, argc, (int far *)&c, 2);
		    continue;
		}
		if (!_fstrcmp(*a, "-p4log") ||  !_fstrcmp(*a, "-log"))
		{
		    strip_out_args(a, argc, (int far *)&c, 1);
		    logging_flag = TRUE;
		    continue;
		}
		if (!_fstrcmp(*a, "-p4norem") ||  !_fstrcmp(*a, "-norem"))
		{
		    strip_out_args(a, argc, (int far *)&c, 1);
		    /* no_remotes = TRUE; */
		    continue;
		}
		if (!_fstrcmp(*a, "-p4version") ||  !_fstrcmp(*a, "-version"))
		{
		    strip_out_args(a, argc, (int far *)&c, 1);
		    print_version_info();
		    continue;
		}
		if (!_fstrcmp(*a, "-p4help") ||  !_fstrcmp(*a, "-help"))
		    usage();  		// doesn't come back
	}
    if (procgroup_file[0] == '\0')
    {
		strcpy(procgroup_file, pgm);
		strcat(procgroup_file,".pg");
		if ((fp = fopen(procgroup_file,"r")) == NULL)  /* pgm.pg not there */
		    strcpy(procgroup_file, "procgroup");       // very default
		else
		    fclose(fp);
    }
    p4_dprintfl(10,"using procgroup file %s\n",procgroup_file);
}

static P4VOID strip_out_args(LPPSTR argv, int far *argc, int far *c, int num)
{
    LPPSTR a;
    int i;

    /* Strip out the argument. */
    for (a = argv, i = (*c); i <= *argc; i++, a++)
		*a = (*(a + num));
    (*argc) -= num;
}

static P4VOID usage(void)
{
    print_version_info();
    printf("p4 usage: %s [p4 options]\n", pgm);
    printf("Valid p4 options (options marked (*) are ignored by P4 for WIN31:\n");
    printf("        -p4help            get this message\n");
    printf("        -p4pg      <file>  set procgroup file\n");
    printf("        -p4dbg    <level>  set debug level\n");
    printf("   (*)  -p4rdbg   <level>  set remote debug level\n");
    printf("        -p4gm      <size>  set globmemsize\n");
    printf("   (*)  -p4dmn   <domain>  set domainname\n");
    printf("        -p4out     <file>  set output file for master\n");
    printf("   (*)  -p4rout    <file>  set output file prefix for remote masters\n");
    printf("   (*)  -p4ssport <port#>  set private port number for secure server\n");
    printf("   (*)  -p4norem           don't start remote processes\n");
#ifdef ALOG_TRACE
    printf("        -p4log             enable internal p4 logging by alog\n");
#endif
    printf("        -p4version         print current p4 version number\n");
    printf("\n");

//    exit(-1);
    p4_error ("Use appropriate options and try again", 0);

}

static P4VOID print_version_info(void)
{
    printf("\n");
    printf("p4 version number:  %s\n", P4_PATCHLEVEL);
    printf("p4  date compiled:  %s\n", P4_COMPILED_TIME);
    printf("p4   machine type:  %s\n", P4_MACHINE_TYPE);

#ifdef P4_DPRINTFL
    printf("   P4_DPRINTFL is:  on\n");
#else
    printf("   P4_DPRINTFL is:  off\n");
#endif

#ifdef ALOG_TRACE
    printf("    ALOG_TRACE is:  on\n");
#else
    printf("    ALOG_TRACE is:  off\n");
#endif

    printf("\n");
}
