
/***********************************************************************
*                                                                      *
*   p4_bm.c                                                            *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <string.h>
#include "p4.h"
#include "p4_sys.h"

//called by master from p4_initenv
int bm_start(int far *argc, LPPSTR argv)
{
    struct local_data *p4_local;

//    sprintf(whoami_p4, "p0_%u", GetCurrentTask());
    p4_dprintfl(90,"entering bm_start\n");
                                                            
    logging_flag = FALSE;
    globmemsize = GLOBMEMSIZE;

    process_args(argc, argv);

    MD_initmem(globmemsize); // empty if xx_shmalloc disabled
    alloc_global();  /* sets p4_global */

    p4_local = alloc_local_bm();
    if (p4_local == NULL)
		p4_error("p4_initenv: alloc_local_bm failed\n", 0);

    MD_initenv();
    usc_init();

    /* big master installing himself */
    install_in_proctable(0, 0, p4_global->my_host_name, P4_MACHINE_TYPE);

    if (logging_flag)
		ALOG_ENABLE;
    else
		ALOG_DISABLE;

    return (0);
}  

//called by slave from p4_initenv
int slave_start(int far *argc, LPPSTR argv)
{
    struct local_data *p4_local;

//    sprintf(whoami_p4, "bm_slave_%u", GetCurrentTask());
    p4_dprintfl(90,"entering slave_start\n");

    p4_local = alloc_local_slave();
	
// CHECK THIS
    /* hang for a valid proctable */
    p4_lock(&p4_global->slave_lock);
    p4_unlock(&p4_global->slave_lock);
	
    setup_conntab();
/* 
   sync with master to make sure all slaves have got proctable
*/
    p4_barrier(&(p4_global->global_barrier),p4_num_total_ids());
	
    p4_dprintfl(20, "local slave starting\n");
    ALOG_SETUP(p4_local->my_id,ALOG_TRUNCATE);
    ALOG_LOG(p4_local->my_id,BEGIN_USER,0,"");
    return (0);  // return of slave - no errors occurred

}
  
  
Int FAR PASCAL _export p4_create_procgroup (void)
{
    p4_dprintfl(90,"entering p4_create_procgroup\n");

    if (p4_get_my_id () != 0)
		return(0);
    if ((p4_global->procgroup = read_procgroup()) == NULL)
		return (-1);
    p4_startup(p4_global->procgroup);
    return(0);
}


Int FAR PASCAL _export p4_startup(struct p4_procgroup far *pg)
{
    Int nslaves;
    struct local_data *p4_local;

    p4_dprintfl(90,"entering p4_startup\n");

    if (p4_global == NULL)
		p4_error("p4 not initialized; perhaps p4_initenv not called",0);
    
    p4_local = get_my_p4_local ();
    // from one entry for each host to one entry for each process
    procgroup_to_proctable(pg);

    setup_conntab();

    /* lock proc table */
    p4_lock(&p4_global->slave_lock);

    if ((nslaves = create_bm_processes(pg)) < 0)
		return (-1);

    /* let local slaves use proc table to identify themselves */
    p4_unlock(&p4_global->slave_lock); 

	/* WIN: We call barrier only once to bring all tasks to same point.
		Wait until all slaves are done with setup_conntab */
    p4_barrier(&(p4_global->global_barrier),p4_num_total_ids());

    return (0);
}

Int create_bm_processes (struct p4_procgroup far *pg)
{
    struct p4_procgroup_entry far *local_pg;
    struct local_data *p4_local;
    struct p4_cluster_data far * pc;
    int		nclustslaves;
    int		slave_idx, cluster_idx;
    HINSTANCE	hSlave;
	struct LOADPARMS {
	    WORD   segEnv;                  /* child environment  */
	    LPSTR  lpszCmdLine;             /* child command tail */
	    LPWORD lpwShow;                 /* how to show child  */
	    LPWORD lpwReserved;             /* must be NULL       */
	} parms;
    WORD awShow[2];

    p4_dprintfl(90, "entering create_bm_processes\n");
    
			
	parms.segEnv = 0;                   /* child inherits environment	*/
	parms.lpszCmdLine = (LPSTR) "";     /* no command line				*/
    awShow[0] = 2;
    awShow[1] = SW_SHOWMINIMIZED;       /* shows child as an icon		*/
	parms.lpwShow = (LPWORD) awShow;    
	parms.lpwReserved = (LPWORD) NULL;  /* must be NULL					*/

    p4_local = get_my_p4_local ();
	p4_global->n_started_slaves = 0;		      			
    
	for (cluster_idx = 0; cluster_idx < pg->num_entries; cluster_idx++)
	{                    
		local_pg = &(pg->entries[cluster_idx]);
	    nclustslaves = (int)local_pg->numslaves_in_group;
	    /* apart from first cluster, masters are started here, too */
	    if (cluster_idx == 0) 
	    {
	    	slave_idx = 1;
	    	nclustslaves++;
	    }
	    else
	    	slave_idx = 0;
	    	
	    // initialize cluster
	    pc = p4_global->clustertab + cluster_idx;
	    pc->local_slave_count = nclustslaves - 1;
		pc->low_cluster_id = p4_global->n_started_slaves;						
		pc->hi_cluster_id  = p4_global->n_started_slaves + nclustslaves;   					
		p4_barrier_init (&(pc->cluster_barrier));
		pc->cluster_shmem = NULL;
		pc->application_id[0] = '\0'; 

	    for (; slave_idx < nclustslaves; slave_idx++)
	    {
			p4_dprintfl(20, "creating process %d of %d\n", 
							slave_idx, nclustslaves);
			
			hSlave = LoadModule(local_pg->slave_full_pathname, &parms);
			
			if (hSlave < HINSTANCE_ERROR)
			    p4_error("create_bm_processes LoadModule failed", hSlave);
			
			p4_dprintfl(10, "created local slave Task%X\n", hSlave);
			
			/* master installing local slaves */
			install_in_proctable(cluster_idx, slave_idx, 
									p4_global->my_host_name, P4_MACHINE_TYPE);
	    }
		p4_global->n_started_slaves += nclustslaves;		      			
    }

    /* Else we're still in the big master */
//    sprintf(whoami_p4, "p0_%ld", GetCurrentTask());

    dump_global(80);
    p4_dprintfl(90, "create_bm_processes: exiting\n");

    return (p4_global->n_started_slaves);
}


P4VOID procgroup_to_proctable(struct p4_procgroup far *pg)
{
    int i, j, ptidx;
    struct p4_procgroup_entry far *pe;

    if (_fstrcmp(pg->entries[0].host_name,"local") == 0)
    {
		_fstrcpy(p4_global->proctable[0].host_name, p4_global->my_host_name);
    }
    else
    {
		p4_dprintfl(10,"hostname in first line of procgroup is %s\n",
			    		pg->entries[0].host_name);
		_fstrcpy(p4_global->my_host_name, pg->entries[0].host_name);
		_fstrcpy(p4_global->proctable[0].host_name, pg->entries[0].host_name);
	}
    get_qualified_hostname(p4_global->proctable[0].host_name);
    p4_dprintfl(10,"hostname for first entry in proctable is %s\n",
		p4_global->proctable[0].host_name);
    p4_global->proctable[0].cluster_idx = 0;
    
    ptidx = 1;
    for (i = 0, pe=pg->entries; i < pg->num_entries; i++, pe++)
    {
		for (j = 0; j < pe->numslaves_in_group; j++)
		{
		    if (i == 0)
				_fstrcpy(p4_global->proctable[ptidx].host_name,
									p4_global->proctable[0].host_name);
		    else
				_fstrcpy(p4_global->proctable[ptidx].host_name,pe->host_name);
		    
		    get_qualified_hostname(p4_global->proctable[ptidx].host_name);
		    p4_global->proctable[ptidx].cluster_idx = i;
		    ptidx++;
		    if (ptidx > P4_MAXPROCS)                                                 
		    // no return
		        p4_error ("Too many processes requested - Limit is: %d", P4_MAXPROCS);
		}
	p4_global->num_in_proctable = ptidx;
    }
}


