
/***********************************************************************
*                                                                      *
*   p4_debug.c                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/


#include <stdarg.h>  // include before <stdio.h> to define va_list to be far
#include <stdio.h>   // really important - near va_list does not work
#include <string.h>
#include "p4.h"
#include "p4_sys.h"

#if defined(p4_dprintfl)
#undef p4_dprintfl
#endif

Int p4_get_dbg_level(void)
{
    return(debug_level);
}


P4VOID p4_set_dbg_level(Int level)
{
    debug_level = level;
}


P4VOID FAR PASCAL _export p4_set_dbg_level_dll(Int level)
{
    debug_level = level;
}


/* WIN used for p4_dprintf(), p4_dprintfl() only */
static char PArgBuf[64]; /* not string, but argument buffer ! */

P4VOID p4_dprintf (char *fmt, ...)
{
	va_list ap;
	
/* WIN whoami_p4 is shared among all tasks; therefore, in WIN we print the task instance
   handle.  However, would be nice to get a p4 task id.
   We do not dare yet to try this because get_my_p4_local() must work to find it.
   Perhaps later       
    printf("%s: ", whoami_p4); */
    printf("Task%4X: ", GetCurrentTask()); 
    va_start (ap, fmt);
    _fmemcpy (PArgBuf, ap, sizeof(PArgBuf) - 1);
    PArgBuf[sizeof(PArgBuf - 1)] = '\0';    
    vprintf (fmt, PArgBuf);
    va_end (fmt); 
}


P4VOID p4_dprintfl (Int level, char *fmt, ...)
{
	va_list ap;
	
    if (level > debug_level)
		return;
		
/*	printf("%ld: %s: ", level, whoami_p4); */
    printf("%2ld: Task%4X: ", level, GetCurrentTask()); 
    va_start (ap, fmt);
    _fmemcpy (PArgBuf, ap, sizeof(PArgBuf) - 1);
    PArgBuf[sizeof(PArgBuf - 1)] = '\0';    
    vprintf (fmt, PArgBuf);
    va_end (fmt); 
}


P4VOID dump_global(Int level)
{
    Int i;
    struct p4_global_data far *g = p4_global;
    struct proc_info far *p;

    if (level > debug_level)
		return;

    p4_dprintf("Dumping global data for Task%4X at %Fp\n", GetCurrentTask(), g);

    for (i = 0, p = g->proctable; i < g->num_in_proctable; i++, p++)
    {
		p4_dprintf(" proctable entry %d:\n", i);
		p4_dprintf("   cluster_idx= %ld\tslave_idx  = %ld \n", 
					p->cluster_idx, p->slave_idx);
    }

    p4_dprintf("    local_slave_count= %ld\n", g->n_started_slaves);
    p4_dprintf("    num_in_proctable = %ld\n", g->num_in_proctable);
}

P4VOID dump_local(Int level)
{
    struct local_data *p4_local = get_my_p4_local ();
    int i;

    if (level > debug_level)
		return;

    p4_dprintf("Dumping local data for task%d at %Np\n", GetCurrentTask(),p4_local);

    for (i = 0; i < p4_global->num_in_proctable; i++)
		p4_dprintf("     %4X: conntab[%d]  type:%s\n", (int)GetCurrentTask(), i,
			   							print_conn_type(p4_local->conntypetab[i]));
	
    p4_dprintf("    my_id       = %ld\n", p4_local->my_id);
    p4_dprintf("    am_bm       = %ld\n", p4_local->am_bm);
}
                                          
char *print_conn_type(Int conn_type)
{
    static char val[32];

    switch (conn_type)
    {
      case CONN_ME:
		return ("CONN_ME");
      case CONN_SHMEM:
		return ("CONN_SHMEM");
      default:
		sprintf(val, "invalid: %ld  ", conn_type);
	return (val);
    }
}


P4VOID dump_procgroup (struct p4_procgroup far *procgroup, Int level)
{
    struct p4_procgroup_entry far *pe;
    int i;

    if (level > debug_level)
		return;

#pragma message ("Fix printing of strings")
    p4_dprintf("Procgroup:\n");
    for (pe = procgroup->entries, i = 0;
    				i < procgroup->num_entries; pe++, i++)
		p4_dprintf("    entry %d: %s %ld %s %s \n",
						   i,
						   pe->host_name,
						   pe->numslaves_in_group,
						   pe->slave_full_pathname,
						   pe->username);
}
 
 
P4VOID dump_tmsg(struct p4_msg far *tmsg)
{
    p4_dprintf("type=%ld, to=%ld, from=%ld, len=%ld, ack_req=%lx, msg=%s\n",
	       tmsg->type, tmsg->to, tmsg->from, tmsg->len, tmsg->ack_req,
	       &(tmsg->msg));
}

P4VOID dump_conntab(Int level)
{
    int i;
    struct local_data *p4_local;
    
    p4_local = get_my_p4_local ();

    if (level > debug_level)
		return;

    for (i = 0; i < p4_global->num_in_proctable; i++)
    {
		p4_dprintf("   conntab[%d] type=%s\n",
			   		i, print_conn_type(p4_local->conntypetab[i]));
    }
}
