
/***********************************************************************
*                                                                      *
*   p4_error.c                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/


#include <process.h>
#include <string.h>
#include <stdarg.h>
#include "p4.h"
#include "p4_sys.h"

Int FAR PASCAL _export p4_soft_errors (Int onoff)
{
    Int old;
    struct local_data *p4_local;
    p4_local = get_my_p4_local ();

    if (!p4_local)
		p4_error("p4_soft_errors: p4_local must be allocated first", 0);

    old = p4_local->soft_errors;
    p4_local->soft_errors = onoff;
    return (old);
}

P4VOID FAR PASCAL _export p4_error(char far *string, Int value)
{ 
    static Int numbuf;  
      
    numbuf = GetCurrentTask ();  
    vsprintf(exportbuf, "Task%4X: ", (va_list)&numbuf);
    _fstrcat (exportbuf, string);
    numbuf = (int)value;
    vsprintf(exportbuf + strlen(exportbuf), " - %ld\n", (va_list)&numbuf);
    
    MessageBox (hwnd, exportbuf, "P4 ERROR", MB_ICONSTOP);
    zap_p4_processes();
    abort ();
}

