
/***********************************************************************
*                                                                      *
*   p4_md.c                                                            *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/


#include <string.h>
#include <sys/timeb.h>
#include <windowsx.h>
#include "p4.h"
#include "p4_sys.h"

/* --------- Most Machine Dependent Stuff is in this file */

P4VOID MD_initmem(unsigned long memsize)
{
#if defined(WIN31) && defined(USE_XX_SHMALLOC)     // NOT TESTED
    void far * lpGlobalMemory;
    unsigned long size;
    
    size = ((memsize + 4095) / 4096) * 4096;
    
    lpGlobalMemory = GlobalLock (GlobalAlloc (GHND, size));
    if (!lpGlobalMemory)
		p4_error("MD_initmem: failed in GlobalAlloc/GlobalLock", size);
    
    xx_init_shmalloc(lpGlobalMemory, size);
#endif
}

/* MD_malloc_hint variables.  Needs to be initialized appropriately
   for each system. */

char far *MD_shmalloc (unsigned long size)
{
    char far *p;

#if defined(WIN31) 
#if defined(USE_XX_SHMALLOC)
    p = xx_shmalloc((unsigned long) size);
#else
#pragma message ("Using WIN GlobalAlloc for shmem")
    p = GlobalLock (GlobalAlloc (GHND | GMEM_SHARE, size));
#endif /* USE_XX_SHMALLOC */   
#else
#pragma message ("MD_shmalloc: Use p4_malloc for shmem")
    p = (char far *) p4_malloc(size);
#endif

    if (!p)
		p4_error("MD_shmalloc: failed allocating memory size ", size);
		
    return (p);
}

P4VOID MD_shfree (char far *ptr)
{    
#if defined(WIN31) 
#if defined(USE_XX_SHMALLOC)
    xx_shfree(ptr);    
#else             
    GlobalFreePtr (ptr);
#endif /* USE_XX_SHMALLOC */
#else
    p4_free(ptr);
#endif
}


p4_usc_time_t usc_MD_rollover_val = 0;

P4VOID usc_init()
{
	unsigned long roll;
    
	roll = (p4_usc_time_t) ((p4_usc_time_t) 1 << ((sizeof(p4_usc_time_t)*8)-1));
	roll = roll + roll - 1;
	usc_MD_rollover_val = (p4_usc_time_t) (roll / 1000000);
}


P4VOID MD_initenv(void)
{

    /* next 2 should stay together -> used in MD_clock */
    p4_global->reference_time = 0; 
    p4_global->reference_time = p4_clock();

}				/* MD_initenv */


Int FAR PASCAL _export p4_clock(void)
{
    Int i;
    static struct _timeb tp;

	_ftime (&tp);
	i = tp.time - p4_global->reference_time;
	i = i * 1000 + tp.millitm;

    return (i);
}


p4_usc_time_t FAR PASCAL _export p4_usrollover(void)
{
    return (usc_MD_rollover_val);
}    

p4_usc_time_t FAR PASCAL _export p4_ustimer(void)
{
	/* Sorry, we cannot be more accurate */
    return ((p4_usc_time_t)p4_clock () * 1000);
}    


Int data_representation(char far *machine_type)
{   
    static char pbuf[16];
/*	if (strcmp(machine_type, "SUN") == 0)             return 1;
    if (strcmp(machine_type, "HP") == 0)              return 1;
    if (strcmp(machine_type, "RS6000") == 0)          return 1;
    if (strcmp(machine_type, "SGI") == 0)             return 1;
    if (strcmp(machine_type, "NEXT") == 0)            return 1;
    if (strcmp(machine_type, "CM5") == 0)             return 1;
    if (strcmp(machine_type, "SYMMETRY") == 0)        return 2;
    if (strcmp(machine_type, "SYMMETRY_PTX") == 0)    return 2;
    if (strcmp(machine_type, "SUN386I") == 0)         return 2;
    if (strcmp(machine_type, "LINUX") == 0)           return 2; */
    if (_fstrcmp(machine_type, "WIN31") == 0)           return 2;	/*  ??? not tested */
/*	if (strcmp(machine_type, "DEC5000") == 0)         return 3;
    if (strcmp(machine_type, "IBM3090") == 0)         return 4;
    if (strcmp(machine_type, "TITAN") == 0)           return 5;
    if (strcmp(machine_type, "FX8") == 0)             return 6;
    if (strcmp(machine_type, "FX2800") == 0)          return 7;
    if (strcmp(machine_type, "FX2800_SWITCH") == 0)   return 7;
    if (strcmp(machine_type, "IPSC860") == 0)         return 8;
    if (strcmp(machine_type, "IPSC860_SOCKETS") == 0) return 8;
    if (strcmp(machine_type, "DELTA") == 0)           return 8;
    if (strcmp(machine_type, "BALANCE") == 0)         return 12;
    if (strcmp(machine_type, "MULTIMAX") == 0)        return 15;
    if (strcmp(machine_type, "CRAY") == 0)            return 16;
    if (strcmp(machine_type, "GP_1000") == 0)         return 17;
    if (strcmp(machine_type, "TC_2000") == 0)         return 18;
    if (strcmp(machine_type, "TC_2000_TCMP") == 0)    return 18;
    if (strcmp(machine_type, "KSR") == 0)             return 19;
    if (strcmp(machine_type, "NCUBE") == 0)           return 20; */
    _fstrncpy (pbuf, machine_type, 15);
    pbuf[15] = '\0';
    printf("%s\n",pbuf);
    p4_error("data_representation: invalid machine type",0);
}
