
/***********************************************************************
*                                                                      *
*   p4_procg.c                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "p4.h"
#include "p4_sys.h"

struct p4_procgroup far * FAR PASCAL _export p4_alloc_procgroup (void)
{
    struct p4_procgroup far *pg;

    pg = (struct p4_procgroup far *) p4_shmalloc(sizeof(struct p4_procgroup));
    if (NULL == pg)
		p4_error("p4_alloc_procgroup: p4_malloc failed",
		 			sizeof(struct p4_procgroup));

    p4_dprintfl(90, "p4_alloc_procgroup: allocating %d bytes\n",
						sizeof(struct p4_procgroup));

    pg->num_entries = 0;
    return (pg);
}

struct p4_procgroup far *read_procgroup(void)
{
    FILE *fp;
    char *s;
    char far *sd;
    struct p4_procgroup_entry far *pe;
    Int n;
    struct p4_procgroup far *pg;

    p4_dprintfl(90,"entering read_procgroup\n");
    pg = p4_alloc_procgroup();

    if ((fp = fopen(procgroup_file, "r")) == NULL)
		p4_error("open error on procgroup file", 0L);

    pe = pg->entries;

    while (fgets(exportbuf, sizeof(exportbuf), fp) != NULL)
    {
		for (s = exportbuf; isspace(*s); s++)
		    ;
	
		if (*s == '#' || *s == '\0')	/* Ignore comments & blanks */
		    continue;
	    /* WIN: May be necessary to find lines with spaces only, too */
		if (pg->num_entries >= P4_MAXCLUSTER)
		    p4_error("read procgroup: too many clusters defined - max. ",
			         (Int) P4_MAXCLUSTER); 
        n = 1;
        sd = pe->host_name;
        while (isgraph (*s))
            *(sd++) = *(s++);
        *sd = '\0';
        while (isspace (*s))
            s++;
            
        if (*s != '\0')
        {
            n++;                                            
			pe->numslaves_in_group = atoi (s);
	        while (isgraph (*s))
	            s++;
	        while (isspace (*s))
	            s++;
		}
        
        if (*s != '\0')
        {
            n++;                                            
	        sd = pe->slave_full_pathname;
	        while (isgraph (*s))
	        {
	            *(sd++) = ('/' == *s) ? '\\' : *s;
	            *(s++);
	        }
	        *sd = '\0';
	        while (isspace (*s))
	            s++;
        }

        if (*s != '\0')
        {
            n++;                                            
	        sd = pe->username;
	        while (isgraph (*s))
	            *(sd++) = *(s++);
	        *sd = '\0';
        }
	    
	    if (0 == pg->num_entries)
	    {	// no executable for first cluster (local) specified
	        _fstrcpy (pe->slave_full_pathname, bm_argv[0]);
	    }
	        
		if (n == 3)
			_fstrcpy(pe->username, "win-user");

		pe++;
		pg->num_entries++;
/*		if (pg->num_entries > P4_MAXCLUSTER)
		    p4_error("read procgroup: too many clusters defined - max. ",
			         (Int) P4_MAXCLUSTER); */
    }

    dump_procgroup (pg,50);
    return (pg);
}				/* read_procgroup */


Int install_in_proctable(	Int cluster_idx, Int slave_idx,					
							char far *host_name, //host_name[64]
							char far *machine_type) //machine_type[]
							
{
    struct p4_global_data far *g;
    struct proc_info far *pi;

    g = p4_global;
    pi = &g->proctable[g->num_installed];
    pi->cluster_idx = cluster_idx;
    _fstrcpy(pi->host_name, (char far *)host_name);
//    _fstrcpy(pi->machine_type, (char far *)machine_type);
    pi->slave_idx = slave_idx;
    g->num_installed++;
    p4_dprintfl(50, "installed in proctable num=%ld host=%s "
    				"slav=%ld clst=%ld \n",
					g->num_installed, host_name, slave_idx, pi->cluster_idx);
    return (g->num_installed - 1);
}

