
/***********************************************************************
*                                                                      *
*   p4_shmem.c                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include "p4.h"
#include "p4_sys.h"

P4BOOL shmem_msgs_available()
{
    Int		qidx;
    P4BOOL	rc;
    struct p4_msg_queue far *mq;
    struct local_data *p4_local;

	p4_local = get_my_p4_local ();                                
    qidx = p4_local->my_id;
    mq = &(p4_global->shmem_msg_queues[qidx]);
    rc = (mq->first_msg != NULL);
    return (rc);
}


struct p4_msg far *shmem_recv(void)
{
    struct p4_msg_queue far *mq;
    struct p4_queued_msg far *q;
    struct p4_msg far *m;
    Int my_qidx, from_qidx;
    struct local_data *p4_local;

	p4_local = get_my_p4_local ();                                
    my_qidx = p4_local->my_id;
    mq = &(p4_global->shmem_msg_queues[my_qidx]);
    p4_dprintfl(60, "receiving shmem messages %ld\n", my_qidx);

    p4_menter(&mq->m);
    if (mq->first_msg == NULL)
    {
		p4_mdelay(&mq->m, 0);
    }
    q = mq->first_msg;
    if (mq->first_msg == mq->last_msg)
    {
		mq->first_msg = NULL;
		mq->last_msg = NULL;
    }
    else
		mq->first_msg = mq->first_msg->next;
    p4_mcontinue(&mq->m, 0);

    from_qidx = q->qmsg->from;
    if (q->qmsg->ack_req & P4_ACK_REQ_MASK)
    {
		p4_dprintfl(30, "sending ack to %ld\n", q->qmsg->from);
		p4_unlock(&(p4_global->shmem_msg_queues[from_qidx].ack_lock));
		p4_dprintfl(30, "sent ack to %ld\n", q->qmsg->from);
    }

    m = q->qmsg;
    free_quel(q);
    p4_dprintfl(60, "received from %ld via shmem\n", q->qmsg->from);
    return (m);
}				/* shmem_recv */


Int shmem_send(struct p4_msg far *tmsg)
{

    struct p4_msg_queue far *mq;
    Int to_qidx, from_qidx;

    p4_dprintfl(20, "sending msg of type %ld from %ld to %ld via shmem\n",
    				tmsg->type, tmsg->from, tmsg->to);
    to_qidx = tmsg->to;
    from_qidx = tmsg->from;
    mq = &(p4_global->shmem_msg_queues[to_qidx]);

    p4_menter(&mq->m);
    queue_p4_message(tmsg, mq);
    p4_mcontinue(&mq->m, 0);

    if (tmsg->ack_req & P4_ACK_REQ_MASK)
    {
		p4_dprintfl(30, "waiting for ack from %ld\n", tmsg->to);
		p4_lock(&(p4_global->shmem_msg_queues[from_qidx].ack_lock));
		p4_dprintfl(30, "received ack from %ld\n", tmsg->to);
    }
    p4_dprintfl(10, "sent msg of type %ld from %ld to %ld via shmem\n",
    				tmsg->type,tmsg->from,tmsg->to);

    return (0);
}
