
/*
 *  $Id: chevent.c,v 1.4 1994/04/06 19:45:06 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   p4event.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char SCCSid[] = "%W% %G%";
#endif

//#include "mpid.h"

/* 
   This file contains routines to see if the "device" wants to do anything
   (like receive some un-expected messages) 
 */
Int MPID_P4_check_device( Int blocking)
{
	if (blocking)
	    MPID_P4_check_incoming( MPID_BLOCKING );
	else 
	    while (MPID_P4_check_incoming( MPID_NOTBLOCKING ) != -1);
	
	/* Question: should we check on pending non-blocking operations here ?
	   Probably not */
	return MPI_SUCCESS;
}

/* Cancel a message.  This is complicated by the fact that we must
   be able to say that a message HAS been cancelled or completed successfully
   given ONLY the status.
 */
Int MPID_P4_Cancel( MPI_Request far *r)
{
	r = r;

	/* If completed, do nothing */
	/* Else:
	   remove from queue
	   mark as cancelled
	   free any storage
	 */
	return MPI_SUCCESS;
}
