
/*
 *  $Id: chinit.c,v 1.16 1994/06/07 19:05:11 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   p4init.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char SCCSid[] = "%W% %G%";
#endif

/* 
    This file contains the routines that provide the basic information 
    on the device, and initialize it
 */

#ifdef WIN31		// MSVC does not offer a switch: compile with 4byte int's
#ifndef Int 
#define Int long	// hope that does not cause too much trouble 
#endif
#endif  
Int __NUMNODES, __MYPROCID ,__P4LEN,__P4TYPE,__P4FROM,__P4GLOBALTYPE ;

#include <malloc.h>
#include <string.h>
//#include "mpid.h"

MPID_INFO *MPID_procinfo = 0;
MPID_H_TYPE MPID_byte_order;
void (*MPID_ErrorHandler)(Int, char far *) = MPID_DefaultErrorHandler;

/* #define DEBUG(a) {a} */
#define DEBUG(a)

static Int DebugSpace = 0;

void MPID_SetSpaceDebugFlag(Int flag)
{
	DebugSpace = flag;
}

void MPID_P4_myrank(Int far *rank)
{
    *rank = __MYPROCID;
}

void MPID_P4_mysize(Int far *size)
{
    *size = __NUMNODES;
}

/* 
    In addition, Chameleon processes many command-line arguments 
 */
void MPID_P4_init(int far *argc, LPPSTR argv)
{
// Int  i;
// char *work;

    p4_initenv(argc,argv);
    
    __MYPROCID = p4_get_my_id();
    if (!__MYPROCID)
        p4_create_procgroup();
        
    __NUMNODES = p4_num_total_slaves()+1;
    
    DEBUG(printf("[%ld] Finished init\n", __MYPROCID );)

/* Turn off the resource monitors */
// #if !defined(euih)
/* If we are euih, we can't use SIGALRM; this call sets SIGALRM to 
   SIG_IGN */
// ;
// #endif

/* #ifdef MPID_HAS_HETERO
DEBUG(printf("[%ld] Checking for heterogeneous systems...\n", __MYPROCID );)
MPID_procinfo = (MPID_INFO *)malloc(__NUMNODES * sizeof(MPID_INFO) );
CHKPTR(MPID_procinfo);
for (i=0; i<__NUMNODES; i++) {
    MPID_procinfo[i].byte_order = MPID_H_NONE;
    } */
/* Set my byte ordering and convert if necessary.  Eventually, this
   should use xdr */
/* i = SYGetByteOrder( );
DEBUG(printf("[%ld] Byte order is %ld\n", __MYPROCID, i );)
if (i == 1)      MPID_byte_order = MPID_H_LSB;
else if (i == 2) MPID_byte_order = MPID_H_MSB;
else             MPID_byte_order = MPID_H_XDR;
MPID_procinfo[__MYPROCID].byte_order = MPID_byte_order; */
/* Everyone uses the same format (MSB) */
/* if (i == 1) 
    SYByteSwapInt( &MPID_procinfo[__MYPROCID].byte_order, 1 );
*/
/* Get everyone else's */
/* work = (char *)malloc(__NUMNODES * sizeof(MPID_INFO) );
CHKPTR( work ); */
/* ASSUMES MPID_INFO is ints */
/* PIgior( MPID_procinfo, __NUMNODES, work, PSAllProcs );
free(work );

DEBUG(printf("[%ld] leaving chinit\n", __MYPROCID );)
#endif */
}

void MPID_P4_Abort (Int code)
{   // Not much going on !!!
//	fprintf( stderr, "Aborting program!\n" );
//	fflush( stderr );
//	fflush( stdout );
	printf("Aborting program!\n" );
	p4_error("", code);
}

void MPID_P4_End (void)
{
	if (MPID_GetMsgDebugFlag()) 
    	MPID_PrintMsgDebug();
    
	if (MPID_procinfo) 
	    MPI_FREE(MPID_procinfo);
/* #ifdef DEVICE_CHAMELEON
if (DebugSpace)
    ;
#endif */
	p4_wait_for_end();
}

static char exp_buf [32];

void MPID_P4_Node_name(char far *name, Int  len)
{
	len = len;

	sprintf(exp_buf ,"%ld",__MYPROCID);
	_fstrcpy (name, exp_buf);
}

double MPID_P4_Wtime (void)
{
    return p4_clock()/1000.0;
}

/* This returns a value that is correct but not the best value that
   could be returned */
double MPID_P4_Wtick (void)
{
	double t1, t2;
	Int    cnt;

	t1 = MPID_P4_Wtime();
	cnt = 1000;
	
	while (cnt-- && (t2 = MPID_P4_Wtime()) <= t1) ;
	
	if (!cnt) 
		return 1.0e6;
	return t2 - t1;
}

void MPID_P4_Error_handler(void (*r)(Int, char far *))
{
	if (r)
	    MPID_ErrorHandler = r;
	else
	    MPID_ErrorHandler = MPID_DefaultErrorHandler;
}

void MPID_DefaultErrorHandler(Int code, char far *str)
{
	if (str) 
//	    fprintf( stderr, "%s\n", str );
	    printf( "%s\n", str );
	
	MPID_P4_Abort( code );
}
