/*
 *  $Id: chprobe.c,v 1.4 1994/05/11 14:21:19 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   p4probe.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id";
#endif /* lint */

//#include "mpid.h"

/*
   Implement probe by checking the unexpected receive queue.

 */
Int MPID_P4_iprobe (Int tag, Int source, Int context_id, 
					Int far *found, MPI_Status far *status)
{
	MPID_RHANDLE far *mpid_recv_handle;
	MPIR_RHANDLE far *dmpi_unexpected;

/* At this time, we check to see if the message has already been received */
	DMPI_search_unexpected_queue( source, tag, context_id, 
				      				found, 0, &dmpi_unexpected );
	if (!*found) 
	{
    /* If nothing there, check for incoming messages.... */
	    MPID_P4_check_incoming( MPID_NOTBLOCKING );
	    DMPI_search_unexpected_queue( source, tag, context_id, 
									  found, 0, &dmpi_unexpected );
    }
	
	if (*found) 
	{
    /* Copy relevant data to status */
	    mpid_recv_handle           = &dmpi_unexpected->dev_rhandle;
	    status->MPI_SOURCE	   = dmpi_unexpected->source;
	    status->count	   = mpid_recv_handle->bytes_as_contig;
	    status->count_in_bytes = mpid_recv_handle->bytes_as_contig;
	    status->MPI_TAG	   = dmpi_unexpected->tag; 
    }
	return MPI_SUCCESS;
}


Int MPID_P4_probe (Int tag, Int source, Int context_id, MPI_Status far *status)
{
	Int found;
	while (1) 
	{
	    MPID_P4_iprobe( tag, source, context_id, &found, status );
	    if (found) 
	    	break;
	    /* Wait for a message */
	    MPID_P4_check_incoming( MPID_BLOCKING );
    }
    return MPI_SUCCESS; // always successful
}
