/*
 *  $Id: chsync.c,v 1.4 1994/05/19 20:21:13 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   p4sync.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vc[] = "$Id: chsync.c,v 1.4 1994/05/19 20:21:13 gropp Exp $";
#endif

#include <malloc.h>
//#include "mpid.h"

static Int DebugFlag = 0;

void MPID_SetSyncDebugFlag( Int f)
{
	DebugFlag = f;
}

/*
   This file contains routines to keep track of synchronous send messages;
   they must be explicitly acknowledged.
 */

typedef struct _MPID_SyncId 
{
    Int id;
    MPIR_SHANDLE far *dmpi_send_handle;
    MPID_SHANDLE far *mpid_send_handle;
    struct _MPID_SyncId far *next;
} MPID_SyncId;

static MPID_SyncId far *head = 0;
static Int         CurId = 1;
/* Get a message id for this message and add to the list */

void MPID_P4_Get_Sync_Id( Int far *mode, MPIR_SHANDLE far *dmpi_handle, 
				MPID_SHANDLE far *mpid_handle)
{
	MPID_SyncId far *new;
	
	*mode		      = *mode | (CurId << MPID_MODE_BITS);

	new		      = (MPID_SyncId far *)MPI_MALLOC(sizeof(MPID_SyncId));
	if (!new) 
		MPID_P4_Abort( MPI_ERR_EXHAUSTED );
	new->id		      = CurId++;
	new->dmpi_send_handle = dmpi_handle;
	new->mpid_send_handle = mpid_handle;
	new->next	      = head;
	head		      = new;
}

void MPID_P4_Lookup_SyncAck( Int mode, LPPMPIR_SHANDLE dmpi_send_handle, 
				LPPMPID_SHANDLE mpid_send_handle)
{
	MPID_SyncId far *cur, far *last;
	Int         modeid = mode >> MPID_MODE_BITS;
	last		  = 0;
	cur		  = head;
	*dmpi_send_handle = 0;
	*mpid_send_handle = 0;
	
	while (cur) 
	{
	    if (cur->id == modeid) 
	    {
			*dmpi_send_handle = cur->dmpi_send_handle;
			*mpid_send_handle = cur->mpid_send_handle;
			if (last) 
				last->next = cur->next;
			else     
				head       = cur->next;
			MPI_FREE(cur);
			return;
		}
	    last = cur;
	    cur  = cur->next;
	}
	/* Error, did not find id! */
	if (!dmpi_send_handle)
//        fprintf( stderr, "Error in processing sync id %lx!\n", modeid );
	    printf("Error in processing sync id %lx!\n", modeid );

}

/* Process a synchronization acknowledgement */
Int MPID_SyncAck (Int mode)
{
	MPIR_SHANDLE far *dmpi_send_handle;
	MPID_SHANDLE far *mpid_send_handle;
	
	/* This is an acknowledgement of a synchronous send; look it up and
	   mark as completed */
	MPID_P4_Lookup_SyncAck( mode, &dmpi_send_handle, &mpid_send_handle );
	if (!dmpi_send_handle) 
	{
	//    fprintf( stderr, "Error in processing sync ack!\n" );
	    printf ("Error in processing sync ack!\n" );
	    return MPI_ERR_INTERN;
	}
	dmpi_send_handle->completed = 1;
	mpid_send_handle->done	    = 1;

// WIN return added
	return MPI_SUCCESS;	
}

/* return an acknowledgment */
void MPID_SyncReturnAck(Int mode, Int from)
{
	MPID_PACKET pkt;

	pkt.mode = (mode & ~ MPID_MODE_MASK) | MPIR_MODE_SYNC_ACK;
	/* Rest of packet is irrelavent */
	
	if (DebugFlag) 
	{
	    printf( 
	   "[%ld]SYNC Starting a send of tag = %ld, dest = %ld, mode=%lx for sync ack\n",
		    __MYPROCID, MPID_PT2PT_TAG, from, pkt.mode );
//	    fflush( stdout );
	}
	p4_sendx(MPID_PT2PT_TAG,from,(char far *)(&pkt),MPID_HEADER_LEN,P4NOX );
}
