/*
 *  $Id: allgatherv.c,v 1.12 1994/06/07 21:29:38 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   algathv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: allgatherv.c,v 1.12 1994/06/07 21:29:38 gropp Exp $";
#endif /* lint */

#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Allgatherv - Gathers data from all tasks and deliver it to all

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. sendcount - number of elements in send buffer (integer) 
. sendtype - data type of send buffer elements (handle) 
. recvcounts - integer array (of length group size) 
containing the number of elements that are received from each process 
. displs - integer array (of length group size). Entry 
 i  specifies the displacement (relative to recvbuf ) at
which to place the incoming data from process  i  
. recvtype - data type of receive buffer elements (handle) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - address of receive buffer (choice) 
@*/
Int MPI_Allgatherv ( void far *sendbuf, Int sendcount, MPI_Datatype sendtype, 
					 void far *recvbuf, Int far *recvcounts, Int far *displs, 
					 MPI_Datatype recvtype, MPI_Comm comm)
{
//  Int size, rank, root;
  Int size, root;
  Int errno = MPI_SUCCESS;
  Int flag;

  /* Check for invalid arguments */
  if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,sendcount) ||
      MPIR_TEST_DATATYPE(comm,sendtype) || MPIR_TEST_DATATYPE(comm,recvtype))
      return MPIR_ERROR(comm, errno, "Error in MPI_ALLGATHERV" ); 

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
			 "Inter-communicator invalid in MPI_ALLGATHERV");
  
  /* Get the size of the communicator */
  MPI_Comm_size ( comm, &size );

  /* Do a gather for each process in the communicator */
  /* This is a sorry way to do this, but for now ... */
  for (root=0; root<size; root++)
    MPI_Gatherv(sendbuf,sendcount,sendtype,
		recvbuf,recvcounts,displs,recvtype,root,comm);

  return (errno);
}
