/*
 *  $Id: opcreate.c,v 1.5 1994/06/07 21:29:48 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   op_creat.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: opcreate.c,v 1.5 1994/06/07 21:29:48 gropp Exp $";
#endif /* lint */

#include <malloc.h>
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@
  MPI_Op_create - Creates a user-defined combination function handle

Input Parameters:
. function - user defined function (function) 
. commute -  true if commutative;  false otherwise. 

Output Parameter:
. op - operation (handle) 
@*/
Int MPI_Op_create( MPI_Uop far *function, Int commute, MPI_Op far *op)
{
  MPI_Op newop;

  newop            = MPI_NEW( struct MPIR_OP );
  if (!newop) 
    return MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_EXHAUSTED, 
                      "Out of space in MPI_OP_CREATE");
  newop->commute   = commute;
  newop->op        = function;
  newop->permanent = 0;
  (*op)            = newop;
  
  return (MPI_SUCCESS);
}
