/*
 *  $Id: red_scat.c,v 1.15 1994/06/07 21:29:49 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   rd_scat.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: red_scat.c,v 1.15 1994/06/07 21:29:49 gropp Exp $";
#endif /* lint */

#include <malloc.h>
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Reduce_scatter - Combines values and scatters the results

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. recvcounts - integer array specifying the 
number of elements in result distributed to each process.
Array must be identical on all calling processes. 
. datatype - data type of elements of input buffer (handle) 
. op - operation (handle) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - starting address of receive buffer (choice) 
@*/
Int MPI_Reduce_scatter ( void far *sendbuf, void far *recvbuf, Int far *recvcnts,
						 MPI_Datatype datatype, MPI_Op op, MPI_Comm comm)
{
  Int   rank, size, i, count=0;
  MPI_Aint extent;
  Int  far *displs;
  void far *buffer;
  Int   errno = MPI_SUCCESS;
  Int   flag;

  /* Check for invalid arguments */
  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_OP(comm,op) ||
       MPIR_TEST_ALIAS(recvbuf,sendbuf) || MPIR_TEST_DATATYPE(comm,datatype))
    return MPIR_ERROR(comm, errno, "Error in MPI_REDUCE_SCATTER" );

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
			  "Inter-communicator invalid in MPI_REDUCE_SCATTER");

  /* Determine the "count" of items to reduce and set the displacements*/
  MPI_Type_extent (datatype, &extent);
  MPI_Comm_size   (comm, &size);
  MPI_Comm_rank   (comm, &rank);

  /* Allocate the displacements and initialize them */
  displs = (Int far *)MPI_MALLOC(size*sizeof(Int));
  if (!displs) 
      return MPIR_ERROR( comm, MPI_ERR_EXHAUSTED, 
			 "Out of space in MPI_REDUCE_SCATTER" );
  for (i=0;i<size;i++) {
    displs[i] = count;
    count += recvcnts[i];
  }

  /* Allocate a temporary buffer */
  buffer = (void far *)MPI_MALLOC(extent*count);
  if (!buffer) 
      return MPIR_ERROR( comm, MPI_ERR_EXHAUSTED, 
			 "Out of space in MPI_REDUCE_SCATTER" );

  /* Reduce to 0, then scatter */
  MPI_Reduce   ( sendbuf, buffer, count, datatype, op, 0, comm);
  MPI_Scatterv ( buffer, displs, recvcnts, datatype, recvbuf, 
				 recvcnts[rank], datatype, 0, comm );
  
  /* Free the temporary buffers */
  MPI_FREE(buffer); MPI_FREE(displs);
  return (errno);
}
