/*
 *  $Id: scan.c,v 1.21 1994/06/07 21:29:51 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   scan.c                                                             *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: scan.c,v 1.21 1994/06/07 21:29:51 gropp Exp $";
#endif /* lint */

#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Scan - Computes the scan (partial reductions) of data on a collection of
           processes

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. count - number of elements in input buffer (integer) 
. datatype - data type of elements of input buffer (handle) 
. op - operation (handle) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - starting address of receive buffer (choice) 
@*/
Int MPI_Scan ( void far *sendbuf, void far *recvbuf, Int count, 
				MPI_Datatype datatype, MPI_Op op, MPI_Comm comm)
{
  MPI_Status status;
  Int        rank, size;
  Int        errno = MPI_SUCCESS;
  MPI_Aint   extent;
  MPI_Uop   *uop;
  Int        flag; 

  /* Check for invalid arguments */
  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_OP(comm,op) ||
//       ( ((count>0)&&(sendbuf==(void *)0))  && (errno = MPI_ERR_BUFFER) ) ||
       ( ((count>0)&&(sendbuf==NULL))  && ((errno = MPI_ERR_BUFFER) != 0)) ||
//       ( ((count>0)&&(recvbuf==(void *)0))  && (errno = MPI_ERR_BUFFER) ) ||
	   ( ((count>0)&&(recvbuf==NULL))  && ((errno = MPI_ERR_BUFFER) != 0)) ||
       MPIR_TEST_ALIAS(sendbuf,recvbuf))
    return MPIR_ERROR( comm, errno, "Error in MPI_SCAN" );
  /* We also need to check that the datatype is a basic type? */

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
					  "Inter-communicator invalid in MPI_SCAN");

  /* Get my rank & size and switch communicators to the hidden collective */
  MPI_Comm_size ( comm, &size );
  MPI_Comm_rank ( comm, &rank );
  MPI_Type_extent ( datatype, &extent );
  comm = comm->comm_coll;
  uop = op->op;

  /* Lock for collective operation */
  MPID_THREAD_LOCK(comm);

  /* Do the scan operation */
  if (rank > 0) {
	MPI_Recv(recvbuf,count,datatype,rank-1,MPIR_SCAN_TAG,comm,&status);
	(*uop)(sendbuf, recvbuf, &count, &datatype); 
  }
  else {
	MPI_Sendrecv(sendbuf,count,datatype,rank, MPIR_SCAN_TAG,
				 recvbuf,count,datatype,rank, MPIR_SCAN_TAG,
				 comm, &status);
  }
  
  /* send the letter to destination */
  if (rank < (size-1)) 
    MPI_Send(recvbuf,count,datatype,rank+1,MPIR_SCAN_TAG,comm);

  /* Unlock for collective operation */
  MPID_THREAD_UNLOCK(comm);

  return(errno);
}
