/*
 *  $Id: attr_getval.c,v 1.12 1994/06/07 21:24:20 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   attr_gv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: attr_getval.c,v 1.12 1994/06/07 21:24:20 gropp Exp $";
#endif /* lint */

/*@C

MPI_Attr_get - Retrieves attribute value by key

Input Parameters:
. comm - communicator to which attribute is attached (handle) 
. keyval - key value (integer) 

Output Parameters:
. attribute_val - attribute value, unless flag = false 
. flag -  true if an attribute value was extracted;  false if no attribute is associated with the key 

@*/
Int MPI_Attr_get ( MPI_Comm comm, Int keyval, LPPVOID attr_value, Int far *flag)
{
  MPIR_HBT_node far *attr;
  Int errno = MPI_SUCCESS;

  if ( MPIR_TEST_COMM(comm,comm)||
	   ( (keyval == MPI_KEYVAL_INVALID) && ((errno = MPI_ERR_OTHER) != 0) ) )
	return MPIR_ERROR(comm, errno, "Error in MPI_ATTR_GET");
		  
  MPIR_HBT_lookup(comm->attr_cache, keyval, &attr);
//  if ( attr == (MPIR_HBT_node *)0 ) {
  if ( attr == NULL ) {
	(*flag) = MPIR_FALSE;
	(*attr_value) = NULL; 
  }
  else {
	(*flag) = MPIR_TRUE;
	(*attr_value) = attr->value;
  }
  return(errno);
}



