/*
 *  $Id: attr_putval.c,v 1.12 1994/06/07 21:24:21 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   attr_pv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Attr_put - Stores attribute value associated with a key

Input Parameters:
. comm - communicator to which attribute will be attached (handle) 
. keyval - key value, as returned by  MPI_KEYVAL_CREATE (integer) 
. attribute_val - attribute value 

@*/
Int MPI_Attr_put ( MPI_Comm comm, Int keyval, void far *attr_value )
{
  MPIR_HBT_node far *attr;
  MPIR_Attr_key far *attr_key = (MPIR_Attr_key far *)keyval;
  Int errno = MPI_SUCCESS;

  /* Check for valid arguments */
  if ( MPIR_TEST_COMM(comm,comm) ||
	   ( (keyval == MPI_KEYVAL_INVALID) && ((errno = MPI_ERR_OTHER) != 0)) )
	return MPIR_ERROR( comm, errno, "Error in MPI_ATTR_PUT" );

  MPIR_HBT_lookup(comm->attr_cache, keyval, &attr);
//  if (attr == (MPIR_HBT_node *)0) {
  if (attr == NULL) {
	(void) MPIR_HBT_new_node ( keyval, attr_value, &attr );
	(void) MPIR_HBT_insert ( comm->attr_cache, attr );
  }
  else {
//	if ( attr_key->delete_fn != (Int(*)())0 )
	if ( attr_key->delete_fn != NULL )
	  (void) attr_key->delete_fn(&comm, &keyval, attr->value,
								 attr_key->extra_state );
	attr->value = attr_value;
  }
  return (errno);
}
