/*
 *  $Id: attr_util.c,v 1.13 1994/06/07 21:24:22 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   attr_uti.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/* 

MPIR_Attr_copy_node -

 */
Int MPIR_Attr_copy_node ( MPI_Comm comm, MPI_Comm comm_new, MPIR_HBT_node far *node)
{
  void          far *attr_val;
  MPIR_Attr_key far *attr_key = (MPIR_Attr_key far *)(node->keyval);
  MPIR_HBT_node far *attr;
  Int            flag;

//  if (attr_key->copy_fn != (Int (*)())0) {
  if (attr_key->copy_fn != NULL) {
	(void) (*(attr_key->copy_fn))(&comm, &node->keyval, attr_key->extra_state,
				  node->value, &attr_val, &flag );
	if (flag) {
      (void) MPIR_HBT_new_node ( node->keyval, attr_val, &attr );
      (void) MPIR_HBT_insert ( comm_new->attr_cache, attr );
    }
  }
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_copy_subtree -

+*/
Int MPIR_Attr_copy_subtree ( MPI_Comm comm, MPI_Comm comm_new, 
							 MPIR_HBT far *tree, MPIR_HBT_node far *subtree)
{
//  if(subtree != (MPIR_HBT_node *)0) {
  if(subtree != NULL) {
    (void) MPIR_Attr_copy_node ( comm, comm_new, subtree );
    (void) MPIR_Attr_copy_subtree ( comm, comm_new, tree, subtree -> left );
    (void) MPIR_Attr_copy_subtree ( comm, comm_new, tree, subtree -> right );
  }
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_copy - copy a tree of attributes 

+*/
Int MPIR_Attr_copy ( MPI_Comm comm, MPI_Comm comm_new)
{
  (void) MPIR_HBT_new_tree ( &(comm_new->attr_cache) );
//  if ( comm_new->attr_cache != (MPIR_HBT *)0 ) {
  if ( comm_new->attr_cache != NULL ) {
    comm_new->attr_cache->ref_count = 1;
    (void) MPIR_Attr_copy_subtree ( comm, comm_new, comm_new->attr_cache,
                                    comm->attr_cache->root );
  }
  return (MPI_SUCCESS);
}


/*+

MPIR_Attr_free_node -

+*/
Int MPIR_Attr_free_node ( MPI_Comm comm, MPIR_HBT_node far *node)
{
  MPIR_Attr_key far *attr_key = (MPIR_Attr_key far *)(node->keyval);

//  if ( (node != (MPIR_HBT_node *)0) && (attr_key != 0) )
  if ( (node != NULL) && (attr_key != 0) )
//    if ( attr_key->delete_fn != (Int (*)())0 ) 
	if ( attr_key->delete_fn != NULL )
// WIN 31 Error in MPICH ???	 
	  (void ) (*(attr_key->delete_fn))(&comm, &node->keyval,
                                       node->value, attr_key->extra_state);
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_free_subtree -

+*/
Int MPIR_Attr_free_subtree ( MPI_Comm comm, MPIR_HBT_node far *subtree)
{
//  if(subtree != (MPIR_HBT_node *)0) {
  if(subtree != NULL) {
    (void) MPIR_Attr_free_subtree ( comm, subtree -> left );
    (void) MPIR_Attr_free_subtree ( comm, subtree -> right );
    (void) MPIR_Attr_free_node ( comm, subtree );
  }
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_free_tree -

+*/
Int MPIR_Attr_free_tree ( MPI_Comm comm )
{
//  if ( ( comm != MPI_COMM_NULL ) && ( comm->attr_cache != (MPIR_HBT *)0 ) ) {
  if ( ( comm != MPI_COMM_NULL ) && ( comm->attr_cache != NULL ) ) {
    if (comm->attr_cache->ref_count <= 1) {
//      if ( comm->attr_cache->root != (MPIR_HBT_node *)0 )
      if ( comm->attr_cache->root != NULL )
        (void) MPIR_Attr_free_subtree ( comm, comm->attr_cache->root );
      (void) MPIR_HBT_free_tree ( comm->attr_cache );
    }
    else
      comm->attr_cache->ref_count--;
  }
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_dup_tree -

+*/
Int MPIR_Attr_dup_tree ( MPI_Comm comm, MPI_Comm new_comm)
{
//  if ( comm->attr_cache != (MPIR_HBT *)0 )
  if ( comm->attr_cache != NULL )
    comm->attr_cache->ref_count++;
  new_comm->attr_cache = comm->attr_cache;
  return (MPI_SUCCESS);
}

/*+

MPIR_Attr_create_tree -

+*/
Int MPIR_Attr_create_tree ( MPI_Comm comm)
{
  (void) MPIR_HBT_new_tree ( &(comm->attr_cache) );
  comm->attr_cache->ref_count = 1;
  return (MPI_SUCCESS);
}



