/*
 *  $Id: comm_rank.c,v 1.11 1994/06/07 21:24:27 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   comm_rk.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: comm_rank.c,v 1.11 1994/06/07 21:24:27 gropp Exp $";
#endif /* lint */

/*@

MPI_Comm_rank - Determines the rank of the calling process in the communicator

Input Parameters:
. comm - communicator (handle) 
Output Parameter:
. rank - rank of the calling process in group of  comm  (integer) 

@*/
Int MPI_Comm_rank ( MPI_Comm comm, Int far *rank)
{
    Int errno;
    if ( MPIR_TEST_COMM(comm,comm) ) 
    {
	(*rank) = MPI_UNDEFINED;
	return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_COMM_RANK" );
    }
    else 
	(*rank) = comm->local_group->local_rank;

  return (MPI_SUCCESS);
}
