/*
 *  $Id: context_util.c,v 1.14 1994/06/07 21:24:32 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/* context_util.c - Utilities used by the context chapter functions */

/***********************************************************************
*                                                                      *
*   context_.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#define MPIR_MAX(a,b)  (((a)>(b))?(a):(b))

/* 

MPIR_Context_alloc - allocate some number of contexts over given communicator

 */
Int MPIR_Context_alloc ( MPI_Comm comm, Int num_contexts, MPIR_CONTEXT far *context)
{
  static MPIR_CONTEXT high_context = MPIR_FIRST_FREE_CONTEXT;

  /* Lock for collective operation */
  MPID_THREAD_LOCK(comm);

  /* Allocate contexts for intra-comms */
  if (comm->comm_type == MPIR_INTRA) {

    /* Find the highest context */
    MPI_Allreduce(&high_context,context,1,MPIR_CONTEXT_TYPE,MPI_MAX,comm);
  }

  /* Allocate contexts for inter-comms */
  else {
    MPIR_CONTEXT rcontext;
    MPI_Status   status;
    MPI_Comm     inter = comm->comm_coll;
    MPI_Comm     intra = inter->comm_coll;
    Int          rank;

    /* Find the highest context on the local group */
    MPI_Allreduce(&high_context,context,1,MPIR_CONTEXT_TYPE,MPI_MAX,intra);

    /* Leaders swap info */
    MPI_Comm_rank ( comm, &rank );
    if (rank == 0) 
      MPI_Sendrecv(   context, 1, MPIR_CONTEXT_TYPE, 0, 0, 
                    &rcontext, 1, MPIR_CONTEXT_TYPE, 0, 0, inter, &status);

    /* Update context to be the highest context */
    (*context) = MPIR_MAX((*context),rcontext);
  }

  /* Reset the highest context */
  high_context = (*context) + num_contexts;

  /* Lock for collective operation */
  MPID_THREAD_UNLOCK(comm);

  return(MPI_SUCCESS); 
}

/*+

MPIR_Context_dealloc - deallocate previously allocated contexts 

+*/
/*ARGSUSED*/
Int MPIR_Context_dealloc ( MPI_Comm comm, Int num, MPIR_CONTEXT context)
{
  comm    = comm;
  num     = num;
  context = context;

  /* This does nothing currently */
  return (MPI_SUCCESS);
}
