/*
 *  $Id: group_free.c,v 1.10 1994/06/07 21:24:35 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   grp_fre.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Group_free - Frees a group

Input Parameter
. group - group (handle) 

Notes:
On output, group is set to MPI_GROUP_NULL.

@*/
Int MPI_Group_free ( MPI_Group far *group)
{
  Int errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_ARG(group) )
	return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_GROUP_FREE" );

  /* Free null groups succeeds silently */
  if ( (*group) == MPI_GROUP_NULL )
	return (MPI_SUCCESS);
	 
  /* We can't free permanent objects unless finalize has been called */
  if  ( ( (*group)->permanent == 1 ) && (MPIR_Has_been_initialized == 1) )
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_PERM_KEY,
					  "Error in MPI_GROUP_FREE" );

  /* Free group */
  if ( (*group)->ref_count <= 1 ) 
	MPIR_FreeGroup(*group);
  else 
	(*group)->ref_count--;
  (*group) = MPI_GROUP_NULL;

  return (errno);
}
