/*
 *  $Id: group_incl.c,v 1.11 1994/06/07 21:24:36 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   grp_inc.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>

/*@

MPI_Group_incl - Produces a group by reordering an existing group and taking
        only listed members

Input Parameters:
. group - group (handle) 
. n - number of elements in array ranks (and size of newgroup ) (integer) 
. ranks - ranks of processes in group to appear in newgroup (array of 
integers) 

Output Parameter:
. newgroup - new group derived from above, in the order defined by ranks 
(handle) 

Note:
This implementation does not currently check to see that the list of
ranks to include are valid ranks in the group.

@*/
Int MPI_Group_incl ( MPI_Group group, Int n, Int far *ranks, 
			MPI_Group far *group_out )
{
  Int       i, rank;
  MPI_Group new_group;
  Int       errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_GROUP(MPI_COMM_WORLD,group) ||
 	   ( ((n>0)&&MPIR_TEST_ARG(ranks)) )   )
    return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_GROUP_INCL" );

  /* Check for a EMPTY input group or EMPTY sized new group */
  if ( (group == MPI_GROUP_EMPTY) || (n <= 0) ) {
    MPIR_Group_dup ( MPI_GROUP_EMPTY, group_out );
    return (errno);
  }
  
  /* Create the new group */
  new_group = (*group_out)  = MPI_NEW(struct MPIR_GROUP);
  if (!new_group) 
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_EXHAUSTED, 
					  "Out of space in MPI_GROUP_INCL" );
  new_group->ref_count      = 1;
  new_group->local_rank     = MPI_UNDEFINED;
  new_group->permanent      = 0;
  new_group->set_mark       = NULL;
  new_group->np             = n;
  new_group->lrank_to_grank = (Int far *) MPI_MALLOC( n * sizeof(Int) );
  if (!new_group->lrank_to_grank) {
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_EXHAUSTED, 
					  "Out of space in MPI_GROUP_INCL" );
  }

  /* Fill in the lrank_to_grank list */
  for (i=0; i<n; i++) {
    if ( (rank = ranks[i]) < group->np )
      new_group->lrank_to_grank[i] = group->lrank_to_grank[rank];
    else
      new_group->lrank_to_grank[i] = MPI_UNDEFINED;
    if (group->local_rank == rank)
      new_group->local_rank = i;
  }

  /* Determine the previous and next powers of 2 */
  MPIR_Powers_of_2 ( new_group->np, &(new_group->N2_next), 
		     &(new_group->N2_prev) );

  return (errno);
}


