/*
 *  $Id: group_tranks.c,v 1.9 1994/06/07 21:24:41 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   grp_trk.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Group_translate_ranks - Translates the ranks of processes in one group to 
                            those in another group

Input Parameters:
. group1 - group1 (handle) 
. n - number of ranks in  ranks1 and ranks2  arrays (integer) 
. ranks1 - array of zero or more valid ranks in group1 
. group2 - group2 (handle) 

Output Parameter:
. ranks2 - array of corresponding ranks in group2,  MPI_UNDEFINED  when no 
correspondence exists. 

@*/
Int MPI_Group_translate_ranks ( MPI_Group group_a, Int n, Int far * ranks_a, 
				MPI_Group group_b, Int far * ranks_b )
{
  Int i, j;
  Int pid_a, rank_a;
  Int errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_GROUP(MPI_COMM_WORLD,group_a) ||
       MPIR_TEST_GROUP(MPI_COMM_WORLD,group_b) || 
	   ( (n       <= 0)              && ((errno = MPI_ERR_ARG) != 0) )   ||
       MPIR_TEST_ARG(ranks_a) || MPIR_TEST_ARG(ranks_b))
    return MPIR_ERROR( MPI_COMM_WORLD, errno, 
				  "Error in MPI_GROUP_TRANSLATE_RANKS" );

  /* Set ranks_b array to MPI_UNDEFINED */
  for ( i=0; i<n; i++ )
    ranks_b[i] = MPI_UNDEFINED;
 
  /* Translate the ranks in ranks_a to ranks_b */
  for ( i=0 ; i<n; i++ ) {
    if ( ((rank_a = ranks_a[i]) >= group_a->np) || (rank_a < 0) ) 
      break;
    pid_a = group_a->lrank_to_grank[rank_a];
    for ( j=0; j<group_b->np; j++ ) 
      if ( pid_a == group_b->lrank_to_grank[j] ) {
        ranks_b[i] = j;
        break;
      }
  }
  return (errno);
}
