/*
 *  $Id: keyval_create.c,v 1.3 1994/06/07 21:24:47 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   kv_creat.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>

/*@

MPI_Keyval_create - Generates a new attribute key

Input Parameters:
. copy_fn - Copy callback function for keyval 
. delete_fn - Delete callback function for keyval 
. extra_state - Extra state for callback functions 

Output Parameter:
. keyval - key value for future access (integer) 

Notes:
Key values are global (available for any and all communicators).
@*/
Int MPI_Keyval_create ( MPI_Copy_function far *copy_fn, MPI_Delete_function far *delete_fn,
			Int far *keyval, void far *extra_state)
{
  MPIR_Attr_key far *new_key = MPI_NEW(MPIR_Attr_key);

  if (!new_key) {
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_EXHAUSTED, 
				  "Out of space in MPI_Keyval_create" );
  }

  /* NOTE: THIS WON'T WORK ON ALL SYSTEMS; IN PARTICULAR, IT WON'T
     WORK ON DEC ALPHA SYSTEMS AND OTHER 64 BIT POINTER, 32 BIT FORTRAN
     INTEGER SYSTEMS */
  (*keyval)              = (Int)new_key;
  /* SEE ALSO THE CODE IN ENV/INIT.C; IT RELIES ON USEING KEY AS THE
     POINTER TO SET THE PERMANENT FIELD */
  new_key->copy_fn       = copy_fn;
  new_key->delete_fn     = delete_fn;
  new_key->ref_count     = 1;
  new_key->extra_state   = extra_state;
  new_key->permanent     = 0;
  return (MPI_SUCCESS);
}

