/*
 *  $Id: keyval_free.c,v 1.6 1994/06/07 21:24:48 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   kv_free.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>

/*@

MPI_Keyval_free - Frees attribute key for communicator cache attribute

Input Parameter:
. keyval - Frees the integer key value (integer) 

Note:
Key values are global (they can be used with any and all communicators)
@*/
Int MPI_Keyval_free ( Int far *keyval)
{
  Int errno;
  MPIR_Attr_key far *attr_key;

  if ( MPIR_TEST_ARG(keyval))
	return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_KEYVAL_FREE");

  attr_key = (MPIR_Attr_key far *)*keyval;
  if ( (*keyval) != MPI_KEYVAL_INVALID ) {
	if ( (attr_key->permanent == 1) && (MPIR_Has_been_initialized == 1) ){
	  return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_PERM_KEY, 
		"Can't free permanent attribute key in MPI_KEYVAL_FREE" );
	}
	if (attr_key->ref_count <= 1) 
	  MPI_FREE ( (MPIR_Attr_key far *)*keyval );
	else
	  attr_key->ref_count--;
	(*keyval) = MPI_KEYVAL_INVALID;
  }
  return (MPI_SUCCESS);
}
