/*
 *  $Id: abort.c,v 1.4 1994/06/07 21:28:38 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   abort.c                                                            *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <stdlib.h>

/*@
   MPI_Abort - Terminates MPI execution environment

Input Parameters:
. comm - communicator of tasks to abort 
. errorcode - error code to return to invoking environment 

Notes:
Terminates all MPI processes associated with the communicator comm; in
most systems (all to date), terminates ALL processes.

@*/
Int MPI_Abort(MPI_Comm comm, Int errorcode)
{
	comm = comm;

	MPID_ABORT( errorcode );
	
	/* If for some reason we get here, force an abort */
//	abort( errorcode );
	abort ();
	
	/* This keeps lint happy */
	return MPI_ERR_UNKNOWN;
}
