/*
 *  $Id: errset.c,v 1.2 1994/06/07 21:28:43 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   errset.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: errset.c,v 1.2 1994/06/07 21:28:43 gropp Exp $";
#endif

/*@
  MPI_Errhandler_set - Sets the error handler for a communicator

Input Parameters:
. comm - communicator to set the error handler for (handle) 
. errhandler - new MPI error handler for communicator (handle) 

@*/
Int MPI_Errhandler_set( MPI_Comm comm, MPI_Errhandler errhandler)
{
	Int errno;
	
	if (MPIR_TEST_COMM(comm,comm)) 
	{
	    return MPIR_ERROR( comm, errno, "Error in MPI_ERRHANDLER_SET" );
	}
	else
	    comm->error_handler = errhandler;

	return MPI_SUCCESS;
}
