/*
 *  $Id: initialize.c,v 1.3 1994/06/07 21:28:47 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   initial.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: initialize.c,v 1.3 1994/06/07 21:28:47 gropp Exp $";
#endif /* lint */

int MPIR_Has_been_initialized = 0;

/*@
   MPI_Initialized - Indicates whether MPI_Init has been called.

Output Parameter:
. flag - Flag is true if MPI_INIT has been called and false otherwise. 

@*/
Int MPI_Initialized( Int far *flag )
{
/* MPI_Init sets MPIR_Has_been_initialized to 1, MPI_Finalize sets to 2.
   Currently, there is no way to determine, if MPI_Finalize has been called,
   other than trapping references to free'd memory.  Perhaps we should set
   MPI_COMM_WORLD to 0 after freeing it?
 */
    *flag = MPIR_Has_been_initialized > 0;
    return MPI_SUCCESS;
}
