
/***********************************************************************
*                                                                      *
*                                                                      *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <windows.h>
#include <malloc.h>
#include <ctype.h>
#include <string.h>
#include "p4.h"
#include "p4_sys.h" 
typedef unsigned int UINT ;

long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG);

int MPI_main (int , LPPSTR );
void ConvertCmdLine (LPSTR, int *, LPPPSTR);

// char szAppName [] = "P4";
static char szClassName [] = "WinMPI";
// static char szAppName [16];
static BOOL		am_master;
static short	cxChar, cyChar;
static short	cxScreen, cyScreen;

/* for getchar */    
int		nVKey;		/* key delivered by WM_CHAR */
p4_lock_t	getc_lock;
BOOL		take_char;
                                   
static Int debug_level = 0;
                                   
HWND	hWnd; 


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{              
    int		argc;
    LPPSTR	argv;
    WNDCLASS	wndclass;
    MSG		msg;
    char	szModuleFileName[100];
    char	szTitleBarText[20];
    char	*pszBaseName;
    int		my_id;
    
	hPrevInstance = hPrevInstance;
	 
    ConvertCmdLine (lpszCmdLine, &argc, (LPPPSTR)&argv);
    GetModuleFileName (hInstance, szModuleFileName, sizeof (szModuleFileName));
    argv[0] = szModuleFileName;

    wndclass.style         = CS_CLASSDC | CS_HREDRAW | CS_VREDRAW ;
    wndclass.lpfnWndProc   = WndProc ;
    wndclass.cbClsExtra    = 0 ;
    wndclass.cbWndExtra    = 0 ;
    wndclass.hInstance     = hInstance ;
//    wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
    wndclass.hIcon         = LoadIcon (hInstance, "MPIicon1") ;
    wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
    wndclass.hbrBackground = GetStockObject (BLACK_BRUSH) ;
    wndclass.lpszMenuName  = NULL ;
    wndclass.lpszClassName = szClassName ;
			                   
    if (RegisterClass (&wndclass))
    {		                            
	am_master = TRUE;	/* Wow, I am the real MPI master */
	take_char = FALSE;	/* no char accepted before getchar invoked */
//	hWnd = CreateWindow (szClassName, "P4",
	hWnd = CreateWindow (szClassName, "MPI",
	                     WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | 
	                     WS_THICKFRAME | WS_MINIMIZEBOX, 
	                     50, 50,
	                     CW_USEDEFAULT, CW_USEDEFAULT,
	                     NULL, NULL, hInstance, NULL) ;
	P4_ScrClear (hWnd);
	ShowWindow (hWnd, nCmdShow);
    }
    else
    {
	am_master = FALSE;	// I am slave
	hWnd = CreateWindow (szClassName, "P4-SLAVE",
	                     WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | 
	                     WS_THICKFRAME | WS_MINIMIZEBOX, 
	                     10, 10, 10, 10,
	                     NULL, NULL, hInstance, NULL) ;
	    	
    	ShowWindow (hWnd, SW_MINIMIZE);
//	UpdateWindow (hWnd);
    }
	
    get_new_p4_local ();    
    
    /* register new package name with p4 (for slave termination) */
    P4WinSetPkgName ("MPI");
    
	strcpy (szTitleBarText, "MPI - ");			                   
    if (am_master)
    {                             
    	if ((pszBaseName = strrchr (szModuleFileName, '\\')) == NULL)
    	    pszBaseName = szModuleFileName;
    	else
    	    pszBaseName++;
		strcpy (szTitleBarText + 6, pszBaseName);
    } 
    else 
    {
		my_id = (int)p4_get_my_id ();
		sprintf (szTitleBarText + 3, "-Rank %d", my_id);
    }
	SetWindowText (hWnd, szTitleBarText);
		
	    
    MPI_main (argc, argv);
    
    p4_dprintfl(20,"process exiting\n");
        
    while (GetMessage(&msg, NULL, 0, 0)) 
    {
        TranslateMessage(&msg); /* translates virtual key codes    */
        DispatchMessage(&msg);  /* dispatches message to window    */
    }
    return msg.wParam;			/* return value of PostQuitMessage */
} 

long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam,
                                                          LONG lParam)
{
    HDC	    hdc;
    HMENU   hSysMenu;
    TEXTMETRIC     tm;
//    WORD awShow[2] = { 2, SW_HIDE };
    PAINTSTRUCT    ps ; 
    RECT     rcw, rcc; 
    MINMAXINFO FAR* lpmmi;
    int i, jb, je;    
        
    if (am_master)
    {
	switch (message)
	{
	    case WM_CREATE:
	        hdc = GetDC (hwnd);
	        SelectObject (hdc, GetStockObject (OEM_FIXED_FONT));
	        SetBkColor (hdc, RGB (0, 0, 0));
	        SetTextColor (hdc, RGB (0, 255, 0));
	        GetTextMetrics (hdc, &tm);
	        cxChar = tm.tmAveCharWidth;
	        cyChar = tm.tmHeight + tm.tmExternalLeading;
	        ReleaseDC (hwnd, hdc);
			    
		GetWindowRect (hwnd, &rcw);
		GetClientRect (hwnd, &rcc);
		cxScreen = (rcw.right - rcw.left) - 
		           (rcc.right - rcc.left) + cxChar * (P4SCRX + 2);
		cyScreen = (rcw.bottom - rcw.top) - 
		           (rcc.bottom - rcc.top) + cyChar * P4SCRY;
			
		MoveWindow (hwnd, rcw.left, rcw.top, cxScreen, cyScreen, TRUE);  
	            
	        return 0 ;
	
	    case WM_CHAR:
		if (!take_char)
		    break;	/* no char buffering at all - perhaps later */
		take_char = FALSE;	/* only one char at a time */
				
		nVKey = wParam;
		p4_unlock (&getc_lock); /* let getchar take the key */
		return 0;
			
	    case WM_SETFOCUS:
		CreateCaret (hwnd, NULL, cxChar, cyChar);
		P4_SetCaretPos ();
		ShowCaret (hwnd);
		return 0;
			    
	    case WM_KILLFOCUS:
		HideCaret (hwnd);
		DestroyCaret ();
		return 0;
			    
	    case WM_PAINT:   
	        if (!GetUpdateRect (hWnd, &rcc, TRUE))
	            return 0;
	        hdc = BeginPaint (hwnd, &ps) ;
	        jb = (rcc.left < cxChar) ? 0 : rcc.left/cxChar - 1;
	        je = (rcc.right - (jb+1) * cxChar + cxChar - 1) / cxChar;
	        if (jb + je > P4SCRX) 
	            je = P4SCRX - jb;
	        for (i = rcc.top / cyChar; i < (rcc.bottom + cyChar - 1) / cyChar; i ++)
	            P4_TextOut (hdc, i, jb, je );
	
	        EndPaint (hwnd, &ps) ;
	        return 0 ;
	               
	    case WM_GETMINMAXINFO:
		lpmmi = (MINMAXINFO FAR*) lParam;
		lpmmi->ptMinTrackSize.x = lpmmi->ptMaxTrackSize.x =
		lpmmi->ptMaxSize.x = cxScreen;
		lpmmi->ptMinTrackSize.y = lpmmi->ptMaxTrackSize.y = 
		lpmmi->ptMaxSize.y = cyScreen;
		return 0;
	
	    case WM_DESTROY:
		zap_p4_processes (); 
	        PostQuitMessage (0) ;
	        return 0 ;
	}
    }
    else // slave 
    {    
	switch (message)
	{    
	    case WM_CREATE:
	        hSysMenu = GetSystemMenu (hwnd, FALSE);
	        DeleteMenu (hSysMenu, SC_RESTORE , MF_BYCOMMAND);
	        DeleteMenu (hSysMenu, SC_SIZE    , MF_BYCOMMAND);
	        DeleteMenu (hSysMenu, SC_MAXIMIZE, MF_BYCOMMAND);
	        DeleteMenu (hSysMenu, SC_MINIMIZE, MF_BYCOMMAND);

            case WM_QUERYOPEN:
	       	return 0;	// keep window iconized		                   
			    	                
	    case WM_SYSCOMMAND:
	        if (wParam == SC_CLOSE)
		{
		    zap_p4_processes ();
		}
		break;

	    case WM_DESTROY: 
	        PostQuitMessage (0) ;
	        return 0 ;
	}
    } 
	
    return DefWindowProc (hwnd, message, wParam, lParam) ;
}
                              

#ifdef getchar
#undef getchar
#endif
int _cdecl getchar (void)
{   
    if (!am_master)
        p4_error ("Slaves cannot use stdin functions", 0);
        
    p4_lock_init (&getc_lock);
    p4_lock (&getc_lock);
    
    take_char = TRUE;
    /* now a WM_CHAR message can deliver a key and unlock the lock */
    p4_lock (&getc_lock);

// <ENTER> delivers '\r' - is this acceptable ???    
    return (nVKey);
}                              


int _fgetchar (void)
{     
    return getchar ();
}                              

char * _cdecl gets (char *buffer)
{                                               
	char	c;
    int		bi = 0;		/* idx of next buffer pos */
    
    while ((c = getchar ()) != '\r')
    {
	    switch (c)
	    {
	        case '\b':		/* BACKSPACE */
	            if (bi > 0) /* if not start of line */
	            {
	                _fputchar ('\b');
	                buffer[--bi] = ' ';
                }
	            break; // process !!!
	        default :
	            if (isprint(c))
	            {
	                _fputchar (c);
	                buffer[bi++] = c;
	            }
	    }
	}        
	_fputchar ('\n');
    buffer[bi] ='\0';
    return (buffer);
}


int scanf (char const *format, ...)
{      
	char	sBuf[120];
    va_list ap;   
    Int my_id;
    Int p1, p2, p3, p4, p5, p6, p7, p8;
    int ret;

	/* prohibit slaves to use scanf but in WIN they could use it */	        
	if ((my_id = p4_get_my_id ()) != 0) 
		p4_error ("Attempt to use scanf by slave ", my_id);
		
    if (gets (sBuf) != sBuf)
    	return (EOF);
/* 
 *	WIN: Why is there no vsscanf ()?  Have to use a vert dirty and incompatible way to 
 *	retrieve the arguments.  Try to just copy bytes without knowing what they represent.
 *	Hope I always copy enough.
 */
    va_start (ap, format);
    p1 = va_arg (ap, Int);
    p2 = va_arg (ap, Int);
    p3 = va_arg (ap, Int);
    p4 = va_arg (ap, Int);
    p5 = va_arg (ap, Int);
    p6 = va_arg (ap, Int);
    p7 = va_arg (ap, Int);
    p8 = va_arg (ap, Int);
    ret = sscanf (sBuf, format, p1, p2, p3, p4, p5, p6, p7, p8);
    va_end (format);
    
    return (ret);    	             
}	        

int _fputchar (int c)
{
    char cc[2];
    
    cc[0] = (char)c;
    cc[1] = '\0';
    P4_Puts ((char far *)cc);
    return (1);
}

int _cdecl puts (const char *string)
{
   P4_Puts ((char far *)string);
   return (1); // always successful
}
                           
#ifdef __BORLANDC__
int _CType vprintf (const char *fmt, va_list ap)
#else
int vprintf (const char *fmt, va_list ap)
#endif
{
	char	pBuf[120];
    int		ret;
#ifdef __BORLANDC__
	ret = vsprintf (pBuf, fmt, ap);
	pBuf[119] = '\0';
#else
   // God bless the inventor of that function !!!
	ret = _vsnprintf (pBuf, 119, fmt, ap);
	pBuf[119] = '\0';
#endif /* __BORLANDC__ */

    // print expanded string to my MPI screen
	P4_Puts (pBuf);
    
    return ret;
} 

int printf (const char *fmt, ...)
{   
    int ret;
    va_list ap;
    
    va_start (ap, fmt);
    ret = vprintf (fmt, ap);
    va_end (fmt);
    
    return ret;
}


P4VOID p4_dprintf (char *fmt, ...)
{
    va_list ap;
    
    printf("Task%d: ", GetCurrentTask()); 
    va_start (ap, fmt);
    vprintf (fmt, ap);
    va_end (fmt);
}


P4VOID p4_dprintfl (Int level, char *fmt, ...)
{
    va_list ap;

    if (level > debug_level)
		return;
		
    printf("%ld: Task%d: ", level, GetCurrentTask()); 
    va_start(ap, fmt);
    vprintf(fmt, ap);
    va_end(fmt);
}


Int p4_get_dbg_level(void)
{
    return(debug_level);
}


P4VOID p4_set_dbg_level(Int level)
{
    debug_level = (int)level;
	p4_set_dbg_level_dll (level);
}


static void ConvertCmdLine (LPSTR lpszCmdLine, int *argc, LPPPSTR argv)
{
    int		i;
    LPSTR   lpszCL;
    PSTR    pszCmdBuf, pszCB;
    BOOL    space;

    pszCmdBuf = malloc (_fstrlen (lpszCmdLine) + 1);
    
    *argc = 1;
    pszCB = pszCmdBuf;
    lpszCL = lpszCmdLine - 1;  
    space = 1;
    while (*(++lpszCL) != '\0')
    {
        if (1 == space)	// reading gap
	        if (isgraph(*lpszCL)) // new parameter found
	        {
	            *(pszCB++) = *lpszCL;
	            space = 0;
	            (*argc)++;
	            continue;
	        }  
	        
	    if (0 == space)	// reading parameter
        {
            if (isspace(*lpszCL) || '\0' == *lpszCL) // next gap found
	        {
	            *(pszCB++) = '\0';
	            space = 1;
	        } 
	        else
	            *(pszCB++) = *lpszCL;
	    }
    }
    *pszCB = '\0';
    
    *argv = malloc ((*argc + 1) * sizeof (**argv));
    
    (*argv)[0] = '\0';
    (*argv)[1] = (LPSTR)pszCmdBuf;
    for (i = 2; i < *argc; i ++)
        (*argv)[i] = (*argv)[i-1] + _fstrlen((*argv)[i-1]) + 1;
    (*argv)[*argc] = NULL;
}    

