/*
 *  $Id: address.c,v 1.7 1994/06/07 21:22:01 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   address.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: address.c,v 1.7 1994/06/07 21:22:01 gropp Exp $";
#endif /* lint */

/*@
    MPI_Address - Gets the address of a location in memory  

Input Parameters:
. location - location in caller memory (choice) 

Output Parameter:
. address - address of location (integer) 

    Note:
    This routine is provided for both the Fortran and C programmers.
    On many systems, the address returned by this routine will be the same
    as produced by the C '&' operator, but this is not required in C and
    may not be true of systems with word- rather than byte-oriented 
    instructions or systems with segmented address spaces.  
@*/

#pragma message (" Check MPI_Address for WIN31")
Int MPI_Address( void far *location, MPI_Aint far *address)
{
//    *address = (long) ((char far *)location - (char far *)MPI_BOTTOM);
    *address = (MPI_Aint far *)((char far *)location - (char far *)MPI_BOTTOM);
    return MPI_SUCCESS;
}
