/*
 *  $Id: bsend.c,v 1.3 1994/06/07 21:22:02 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   bsend.c                                                            *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: bsend.c,v 1.3 1994/06/07 21:22:02 gropp Exp $";
#endif /* lint */

/*@
    MPI_Bsend - Basic send with user-specified buffering

Input Parameters:
. buf - initial address of send buffer (choice) 
. count - number of elements in send buffer (nonnegative integer) 
. datatype - datatype of each send buffer element (handle) 
. dest - rank of destination (integer) 
. tag - message tag (integer) 
. comm - communicator (handle) 

Note:
This routine does not yet implement the required buffering.
@*/
Int MPI_Bsend( void far *buf, Int count, MPI_Datatype datatype, 
				Int dest, Int tag, MPI_Comm comm)
{
    MPI_Request handle;
    MPI_Status  status;
    Int         errno = MPI_SUCCESS;

    if (dest != MPI_PROC_NULL)
    {
        if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,count) ||
		    MPIR_TEST_DATATYPE(comm,datatype) || 
		    MPIR_TEST_SEND_RANK(comm,dest) || MPIR_TEST_SEND_TAG(comm,tag))
		{
		    MPIR_ERROR( comm, errno, "Error in MPI_Bsend" );
	    }

	MPI_Ibsend( buf, count, datatype, dest, tag, comm, &handle );
	errno = MPI_Wait( &handle, &status );
    }
    return errno;
}
