/*
 *  $Id: bufattach.c,v 1.2 1994/06/07 21:22:04 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   bufatch.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: bufattach.c,v 1.2 1994/06/07 21:22:04 gropp Exp $";
#endif /* lint */

/*@
  MPI_Buffer_attach - Attaches a user-defined buffer for sending

Input Parameters:
. buffer - initial buffer address (choice) 
. size - buffer size, in bytes (integer) 

@*/
Int MPI_Buffer_attach( void far *buffer, Int size)
{
if (MPIR_Buffer_size > 0) 
    return MPIR_ERROR( (MPI_Comm)0, MPI_ERR_BUFFER_EXISTS, 
		       "Error in MPI_BUFFER_ATTACH" );
MPIR_Buffer_size = size;
MPIR_Buffer = buffer;

return MPI_SUCCESS;
}
