/*
 *  $Id: commreq_free.c,v 1.7 1994/06/07 21:22:06 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   comrq_f.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>

/*@
    MPI_Request_free - Frees a communication request object

Input Parameter:
. request - communication request (handle) 
@*/
Int MPI_Request_free( MPI_Request far *request)
{
    Int errno = MPI_SUCCESS;

    if (MPIR_TEST_ARG(request))
	return MPIR_ERROR(MPI_COMM_WORLD,errno,"Erron in MPI_REQUEST_FREE" );
    if ((*request)->type == MPIR_SEND)
    {
	MPID_free_send_handle(&((*request)->shandle.dev_shandle));
	MPIR_SBfree( MPIR_shandles, *request );
    }
    else if ((*request)->type == MPIR_RECV)
    {
	MPID_free_recv_handle(&((*request)->rhandle.dev_rhandle));
	MPIR_SBfree( MPIR_rhandles, *request );
    }
    else
	errno = MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_INTERN, 
			    "MPI_Request_free:  bad request type" );

    *request = MPI_REQUEST_NULL;
    return errno;
}

